/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.consumer.report;

import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.math.BigInteger;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;
import org.somda.sdc.biceps.common.storage.PreprocessingException;
import org.somda.sdc.biceps.consumer.access.RemoteMdibAccess;
import org.somda.sdc.biceps.model.participant.MdibVersion;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.common.util.AutoLock;
import org.somda.sdc.glue.common.MdibVersionUtil;
import org.somda.sdc.glue.consumer.report.ReportProcessingException;
import org.somda.sdc.glue.consumer.report.helper.EpisodicReport;
import org.somda.sdc.glue.consumer.report.helper.ReportWriter;

public class ReportProcessor
extends AbstractIdleService {
    private static final Logger LOG = LogManager.getLogger(ReportProcessor.class);
    private final ReentrantLock mdibReadyLock;
    private final Condition mdibReadyCondition;
    private final MdibVersionUtil mdibVersionUtil;
    private final ReportWriter reportWriter;
    private final BlockingQueue<EpisodicReport> bufferedReports;
    private final Logger instanceLogger;
    private final Boolean applyReportsSameMdibVersion;
    private final AtomicBoolean bufferingRequested;
    private RemoteMdibAccess mdibAccess;
    private Consumer<EpisodicReport> writeReport;

    @Inject
    ReportProcessor(ReentrantLock mdibReadyLock, MdibVersionUtil mdibVersionUtil, ReportWriter reportWriter, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier, @Named(value="SdcGlue.Consumer.ApplyReportsWithSameMdibVersion") Boolean applyReportsSameMdibVersion) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.mdibReadyLock = mdibReadyLock;
        this.mdibReadyCondition = mdibReadyLock.newCondition();
        this.mdibVersionUtil = mdibVersionUtil;
        this.reportWriter = reportWriter;
        this.bufferedReports = new ArrayBlockingQueue<EpisodicReport>(500);
        this.mdibAccess = null;
        this.bufferingRequested = new AtomicBoolean(true);
        this.applyReportsSameMdibVersion = applyReportsSameMdibVersion;
        this.startAsync().awaitRunning();
        this.initMdibAccessWait();
    }

    public void processEpisodicReport(EpisodicReport report) {
        try (AutoLock ignored = AutoLock.lock((Lock)this.mdibReadyLock);){
            this.writeReport.accept(report);
        }
    }

    public void startApplyingReportsOnMdib(RemoteMdibAccess mdibAccess) throws PreprocessingException, ReportProcessingException {
        try (AutoLock ignored = AutoLock.lock((Lock)this.mdibReadyLock);){
            if (this.mdibAccess != null) {
                this.instanceLogger.warn("Tried to invoke startApplyingReportsOnMdib() multiple times. Make sure to call it only once. Invocation ignored.");
                return;
            }
        }
        this.applyEpisodicReportsFromBuffer(mdibAccess);
        this.bufferingRequested.set(false);
        this.applyEpisodicReportsFromBuffer(mdibAccess);
        ignored = AutoLock.lock((Lock)this.mdibReadyLock);
        try {
            this.mdibAccess = mdibAccess;
            this.mdibReadyCondition.signalAll();
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    private void applyEpisodicReportsFromBuffer(RemoteMdibAccess mdibAccess) throws PreprocessingException, ReportProcessingException {
        while (!this.bufferedReports.isEmpty()) {
            try {
                this.applyEpisodicReportOnMdib(this.bufferedReports.take(), mdibAccess);
            }
            catch (InterruptedException e) {
                throw new ReportProcessingException("Could not take an element from the queue though expected");
            }
        }
    }

    private void applyEpisodicReportOnMdib(EpisodicReport report) throws PreprocessingException, ReportProcessingException {
        this.applyEpisodicReportOnMdib(report, this.mdibAccess);
    }

    private void applyEpisodicReportOnMdib(EpisodicReport report, RemoteMdibAccess mdibAccess) throws PreprocessingException, ReportProcessingException {
        MdibVersion mdibAccessMdibVersion = mdibAccess.getMdibVersion();
        MdibVersion reportMdibVersion = this.mdibVersionUtil.getMdibVersion(report.getAbstractReport());
        if (!mdibAccessMdibVersion.getSequenceId().equals(reportMdibVersion.getSequenceId()) || !this.equalsInstanceIds(mdibAccessMdibVersion.getInstanceId(), reportMdibVersion.getInstanceId())) {
            throw new ReportProcessingException(String.format("MDIB version from MDIB (%s) and MDIB version from report (%s) do not match", mdibAccessMdibVersion, reportMdibVersion));
        }
        if (mdibAccessMdibVersion.getVersion().compareTo(reportMdibVersion.getVersion()) == 0) {
            LOG.debug("Received a second report with Mdib Version {}", (Object)reportMdibVersion.getVersion());
            if (!this.applyReportsSameMdibVersion.booleanValue()) {
                return;
            }
        } else if (mdibAccessMdibVersion.getVersion().compareTo(reportMdibVersion.getVersion()) > 0) {
            LOG.debug("Received a report older than current mdib. Mdib {}, report {}", (Object)mdibAccessMdibVersion.getVersion(), (Object)reportMdibVersion.getVersion());
            return;
        }
        this.reportWriter.write(report, mdibAccess);
    }

    private void initMdibAccessWait() {
        this.writeReport = report -> {
            if (this.bufferingRequested.get()) {
                this.bufferedReports.add((EpisodicReport)report);
                return;
            }
            try (AutoLock ignored = AutoLock.lock((Lock)this.mdibReadyLock);){
                if (this.mdibAccess == null) {
                    if (!this.mdibReadyCondition.await(10000L, TimeUnit.MILLISECONDS)) {
                        throw new TimeoutException("No MDIB access set within 10s");
                    }
                    if (this.mdibAccess == null) {
                        throw new NullPointerException("Expected MDIB access to be set, but was null");
                    }
                }
                this.applyEpisodicReportOnMdib((EpisodicReport)report);
                this.writeReport = abstractReport -> {
                    try {
                        this.applyEpisodicReportOnMdib((EpisodicReport)abstractReport);
                    }
                    catch (PreprocessingException | ReportProcessingException e) {
                        throw new RuntimeException(e);
                    }
                };
            }
            catch (InterruptedException | TimeoutException | PreprocessingException | ReportProcessingException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private boolean equalsInstanceIds(BigInteger mdibVersionInstanceId, @Nullable BigInteger reportInstanceId) {
        return reportInstanceId == null ? mdibVersionInstanceId.equals(BigInteger.ZERO) : mdibVersionInstanceId.equals(reportInstanceId);
    }

    protected void startUp() {
    }

    protected void shutDown() {
        try (AutoLock ignored = AutoLock.lock((Lock)this.mdibReadyLock);){
            this.writeReport = abstractReport -> {};
        }
    }
}

