/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.consumer.report.helper;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.somda.sdc.biceps.common.MdibDescriptionModification;
import org.somda.sdc.biceps.common.MdibDescriptionModificationType;
import org.somda.sdc.biceps.common.MdibDescriptionModifications;
import org.somda.sdc.biceps.common.MdibStateModifications;
import org.somda.sdc.biceps.common.Pair;
import org.somda.sdc.biceps.common.PairException;
import org.somda.sdc.biceps.common.storage.PreprocessingException;
import org.somda.sdc.biceps.consumer.access.RemoteMdibAccess;
import org.somda.sdc.biceps.model.message.AbstractAlertReport;
import org.somda.sdc.biceps.model.message.AbstractComponentReport;
import org.somda.sdc.biceps.model.message.AbstractContextReport;
import org.somda.sdc.biceps.model.message.AbstractMetricReport;
import org.somda.sdc.biceps.model.message.AbstractOperationalStateReport;
import org.somda.sdc.biceps.model.message.AbstractReport;
import org.somda.sdc.biceps.model.message.DescriptionModificationReport;
import org.somda.sdc.biceps.model.message.DescriptionModificationType;
import org.somda.sdc.biceps.model.message.WaveformStream;
import org.somda.sdc.biceps.model.participant.AbstractContextDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractContextState;
import org.somda.sdc.biceps.model.participant.AbstractDescriptor;
import org.somda.sdc.biceps.model.participant.AbstractState;
import org.somda.sdc.biceps.model.participant.MdsDescriptor;
import org.somda.sdc.glue.common.MdibVersionUtil;
import org.somda.sdc.glue.consumer.report.ReportProcessingException;
import org.somda.sdc.glue.consumer.report.helper.EpisodicReport;

public class ReportWriter {
    private final MdibVersionUtil mdibVersionUtil;

    @Inject
    ReportWriter(MdibVersionUtil mdibVersionUtil) {
        this.mdibVersionUtil = mdibVersionUtil;
    }

    public void write(EpisodicReport report, RemoteMdibAccess mdibAccess) throws ReportProcessingException, PreprocessingException {
        if (report instanceof EpisodicReport.Waveform) {
            EpisodicReport.Waveform waveformReport = (EpisodicReport.Waveform)report;
            this.write((AbstractReport)waveformReport.getReport(), this.makeModifications(waveformReport.getReport()), mdibAccess);
        } else if (report instanceof EpisodicReport.Metric) {
            EpisodicReport.Metric metricReport = (EpisodicReport.Metric)report;
            this.write((AbstractReport)metricReport.getReport(), this.makeModifications((AbstractMetricReport)metricReport.getReport()), mdibAccess);
        } else if (report instanceof EpisodicReport.Alert) {
            EpisodicReport.Alert alertReport = (EpisodicReport.Alert)report;
            this.write((AbstractReport)alertReport.getReport(), this.makeModifications((AbstractAlertReport)alertReport.getReport()), mdibAccess);
        } else if (report instanceof EpisodicReport.Operation) {
            EpisodicReport.Operation operationReport = (EpisodicReport.Operation)report;
            this.write((AbstractReport)operationReport.getReport(), this.makeModifications((AbstractOperationalStateReport)operationReport.getReport()), mdibAccess);
        } else if (report instanceof EpisodicReport.Component) {
            EpisodicReport.Component componentReport = (EpisodicReport.Component)report;
            this.write((AbstractReport)componentReport.getReport(), this.makeModifications((AbstractComponentReport)componentReport.getReport()), mdibAccess);
        } else if (report instanceof EpisodicReport.Context) {
            EpisodicReport.Context contextReport = (EpisodicReport.Context)report;
            this.write((AbstractReport)contextReport.getReport(), this.makeModifications((AbstractContextReport)contextReport.getReport()), mdibAccess);
        } else if (report instanceof EpisodicReport.Description) {
            EpisodicReport.Description descriptionReport = (EpisodicReport.Description)report;
            this.write(descriptionReport.getReport(), mdibAccess);
        } else {
            throw new ReportProcessingException(String.format("Unexpected report type: %s", report.getClass().getSimpleName()));
        }
    }

    private void write(AbstractReport report, MdibStateModifications modifications, RemoteMdibAccess mdibAccess) throws PreprocessingException {
        mdibAccess.writeStates(this.mdibVersionUtil.getMdibVersion(report), modifications);
    }

    private void write(DescriptionModificationReport report, RemoteMdibAccess mdibAccess) throws ReportProcessingException, PreprocessingException {
        mdibAccess.writeDescription(this.mdibVersionUtil.getMdibVersion((AbstractReport)report), null, null, this.mdibDescriptionModifications(report));
    }

    private MdibDescriptionModifications mdibDescriptionModifications(DescriptionModificationReport report) throws ReportProcessingException {
        MdibDescriptionModifications modifications = new MdibDescriptionModifications();
        ArrayList partModifications = new ArrayList();
        for (DescriptionModificationReport.ReportPart reportPart : report.getReportPart()) {
            MdibDescriptionModificationType modType = ReportWriter.mapModType(reportPart.getModificationType());
            Optional<String> parentDescriptor = Optional.ofNullable(reportPart.getParentDescriptor());
            HashMap<String, List> stateMap = new HashMap<String, List>();
            for (AbstractState state : reportPart.getState()) {
                String descriptorHandle = state.getDescriptorHandle();
                stateMap.computeIfAbsent(descriptorHandle, k -> new ArrayList()).add(state);
            }
            Set descriptorHandles = reportPart.getDescriptor().stream().map(AbstractDescriptor::getHandle).collect(Collectors.toSet());
            List<String> unknownDescriptors = stateMap.keySet().stream().filter(abstractStates -> !descriptorHandles.contains(abstractStates)).toList();
            if (!unknownDescriptors.isEmpty()) {
                throw new ReportProcessingException(String.format("State(s) %s had no matching descriptor in report", String.join((CharSequence)", ", unknownDescriptors)));
            }
            ArrayList<Object> descriptionModifications = new ArrayList<Object>();
            for (AbstractDescriptor descriptor : reportPart.getDescriptor()) {
                AbstractState state;
                List states;
                Optional<List> statesOpt = Optional.ofNullable((List)stateMap.remove(descriptor.getHandle()));
                if (descriptor instanceof AbstractContextDescriptor) {
                    ArrayList<AbstractContextState> contextStates = new ArrayList<AbstractContextState>();
                    if (statesOpt.isPresent()) {
                        List states2 = statesOpt.orElseThrow();
                        for (AbstractState state2 : states2) {
                            if (!(state2 instanceof AbstractContextState)) {
                                throw new ReportProcessingException("MultiState descriptor with single state type");
                            }
                            contextStates.add((AbstractContextState)state2);
                        }
                    }
                    if (modType == MdibDescriptionModificationType.INSERT) {
                        try {
                            descriptionModifications.add(new MdibDescriptionModification.Insert(Pair.tryFromThrowing((AbstractDescriptor)descriptor, contextStates), parentDescriptor.orElseThrow(() -> new ReportProcessingException(String.format("MultiState %s with unknown parent descriptor", descriptor.getHandle())))));
                            continue;
                        }
                        catch (PairException e) {
                            throw new ReportProcessingException(e);
                        }
                    }
                    if (modType == MdibDescriptionModificationType.UPDATE) {
                        try {
                            descriptionModifications.add(new MdibDescriptionModification.Update(Pair.tryFromThrowing((AbstractDescriptor)descriptor, contextStates)));
                            continue;
                        }
                        catch (PairException e) {
                            throw new ReportProcessingException(e);
                        }
                    }
                    descriptionModifications.add(new MdibDescriptionModification.Delete(descriptor.getHandle()));
                    continue;
                }
                if (modType == MdibDescriptionModificationType.INSERT) {
                    if (statesOpt.isEmpty()) {
                        throw new ReportProcessingException(String.format("No states present for descriptor %s", descriptor.getHandle()));
                    }
                    states = statesOpt.orElseThrow();
                    if (states.size() != 1) {
                        throw new ReportProcessingException(String.format("Descriptor %s only allows single state, found %s", descriptor.getHandle(), states.size()));
                    }
                    state = (AbstractState)states.remove(0);
                    String parentDesc = null;
                    if (!(descriptor instanceof MdsDescriptor)) {
                        parentDesc = parentDescriptor.orElseThrow(() -> new ReportProcessingException(String.format("SingleState %s with unknown parent descriptor that is not Mds", descriptor.getHandle())));
                    }
                    try {
                        descriptionModifications.add(new MdibDescriptionModification.Insert(Pair.tryFromThrowing((AbstractDescriptor)descriptor, (AbstractState)state), parentDesc));
                        continue;
                    }
                    catch (PairException e) {
                        throw new ReportProcessingException(e);
                    }
                }
                if (modType == MdibDescriptionModificationType.UPDATE) {
                    if (statesOpt.isEmpty()) {
                        throw new ReportProcessingException(String.format("No states present for descriptor %s", descriptor.getHandle()));
                    }
                    states = statesOpt.orElseThrow();
                    if (states.size() != 1) {
                        throw new ReportProcessingException(String.format("Descriptor %s only allows single state, found %s", descriptor.getHandle(), states.size()));
                    }
                    state = (AbstractState)states.remove(0);
                    try {
                        descriptionModifications.add(new MdibDescriptionModification.Update(Pair.tryFromThrowing((AbstractDescriptor)descriptor, (AbstractState)state)));
                        continue;
                    }
                    catch (PairException e) {
                        throw new ReportProcessingException(e);
                    }
                }
                descriptionModifications.add(new MdibDescriptionModification.Delete(descriptor.getHandle()));
            }
            partModifications.addAll(descriptionModifications);
        }
        try {
            modifications.addAll(partModifications);
        }
        catch (RuntimeException e) {
            throw new ReportProcessingException(e);
        }
        return modifications;
    }

    private MdibStateModifications makeModifications(WaveformStream report) {
        return new MdibStateModifications.Waveform(report.getState());
    }

    private MdibStateModifications makeModifications(AbstractMetricReport report) {
        int capacity = report.getReportPart().stream().mapToInt(rp -> rp.getMetricState().size()).sum();
        ArrayList states = new ArrayList(capacity);
        for (AbstractMetricReport.ReportPart reportPart : report.getReportPart()) {
            states.addAll(reportPart.getMetricState());
        }
        return new MdibStateModifications.Metric(states);
    }

    private MdibStateModifications makeModifications(AbstractAlertReport report) {
        int capacity = report.getReportPart().stream().mapToInt(rp -> rp.getAlertState().size()).sum();
        ArrayList states = new ArrayList(capacity);
        for (AbstractAlertReport.ReportPart reportPart : report.getReportPart()) {
            states.addAll(reportPart.getAlertState());
        }
        return new MdibStateModifications.Alert(states);
    }

    private MdibStateModifications makeModifications(AbstractComponentReport report) {
        int capacity = report.getReportPart().stream().mapToInt(rp -> rp.getComponentState().size()).sum();
        ArrayList states = new ArrayList(capacity);
        for (AbstractComponentReport.ReportPart reportPart : report.getReportPart()) {
            states.addAll(reportPart.getComponentState());
        }
        return new MdibStateModifications.Component(states);
    }

    private MdibStateModifications makeModifications(AbstractContextReport report) {
        int capacity = report.getReportPart().stream().mapToInt(rp -> rp.getContextState().size()).sum();
        ArrayList states = new ArrayList(capacity);
        for (AbstractContextReport.ReportPart reportPart : report.getReportPart()) {
            states.addAll(reportPart.getContextState());
        }
        return new MdibStateModifications.Context(states);
    }

    private MdibStateModifications makeModifications(AbstractOperationalStateReport report) {
        int capacity = report.getReportPart().stream().mapToInt(rp -> rp.getOperationState().size()).sum();
        ArrayList states = new ArrayList(capacity);
        for (AbstractOperationalStateReport.ReportPart reportPart : report.getReportPart()) {
            states.addAll(reportPart.getOperationState());
        }
        return new MdibStateModifications.Operation(states);
    }

    private static MdibDescriptionModificationType mapModType(@Nullable DescriptionModificationType modificationType) {
        if (modificationType == null) {
            return MdibDescriptionModificationType.UPDATE;
        }
        return switch (modificationType) {
            default -> throw new IncompatibleClassChangeError();
            case DescriptionModificationType.CRT -> MdibDescriptionModificationType.INSERT;
            case DescriptionModificationType.UPT -> MdibDescriptionModificationType.UPDATE;
            case DescriptionModificationType.DEL -> MdibDescriptionModificationType.DELETE;
        };
    }
}

