/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.consumer.sco;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.somda.sdc.biceps.model.message.InvocationState;
import org.somda.sdc.biceps.model.message.OperationInvokedReport;
import org.somda.sdc.biceps.model.participant.MdibVersion;

public class ScoUtil {
    @Inject
    ScoUtil() {
    }

    public boolean hasFinalReport(Collection<Pair<OperationInvokedReport.ReportPart, MdibVersion>> reportParts) {
        return this.getFinalReport(reportParts).isPresent();
    }

    public Optional<Pair<OperationInvokedReport.ReportPart, MdibVersion>> getFinalReport(Collection<Pair<OperationInvokedReport.ReportPart, MdibVersion>> reportParts) {
        for (Pair<OperationInvokedReport.ReportPart, MdibVersion> reportPart : reportParts) {
            if (!this.isFinalReport((OperationInvokedReport.ReportPart)reportPart.getLeft())) continue;
            return Optional.of(reportPart);
        }
        return Optional.empty();
    }

    public boolean isFinalReport(OperationInvokedReport.ReportPart reportPart) {
        return switch (reportPart.getInvocationInfo().getInvocationState()) {
            default -> throw new IncompatibleClassChangeError();
            case InvocationState.CNCLLD, InvocationState.CNCLLD_MAN, InvocationState.FIN, InvocationState.FIN_MOD, InvocationState.FAIL -> true;
            case InvocationState.WAIT, InvocationState.START -> false;
        };
    }
}

