/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.guice;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Named;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.somda.sdc.common.util.ExecutorWrapperService;
import org.somda.sdc.glue.common.MdibMapper;
import org.somda.sdc.glue.common.ModificationsBuilder;
import org.somda.sdc.glue.common.factory.MdibMapperFactory;
import org.somda.sdc.glue.common.factory.ModificationsBuilderFactory;
import org.somda.sdc.glue.consumer.SdcRemoteDevice;
import org.somda.sdc.glue.consumer.SdcRemoteDeviceImpl;
import org.somda.sdc.glue.consumer.SdcRemoteDeviceWatchdog;
import org.somda.sdc.glue.consumer.SdcRemoteDevicesConnector;
import org.somda.sdc.glue.consumer.SdcRemoteDevicesConnectorImpl;
import org.somda.sdc.glue.consumer.factory.SdcRemoteDeviceFactory;
import org.somda.sdc.glue.consumer.factory.SdcRemoteDeviceWatchdogFactory;
import org.somda.sdc.glue.consumer.localization.LocalizationServiceProxy;
import org.somda.sdc.glue.consumer.localization.factory.LocalizationServiceProxyFactory;
import org.somda.sdc.glue.consumer.sco.factory.OperationInvocationDispatcherFactory;
import org.somda.sdc.glue.consumer.sco.factory.ScoControllerFactory;
import org.somda.sdc.glue.consumer.sco.helper.OperationInvocationDispatcher;
import org.somda.sdc.glue.guice.Consumer;
import org.somda.sdc.glue.guice.WatchdogScheduledExecutor;
import org.somda.sdc.glue.provider.SdcDevice;
import org.somda.sdc.glue.provider.factory.SdcDeviceFactory;
import org.somda.sdc.glue.provider.localization.LocalizationService;
import org.somda.sdc.glue.provider.localization.LocalizationServiceImpl;
import org.somda.sdc.glue.provider.localization.factory.LocalizationServiceFactory;
import org.somda.sdc.glue.provider.sco.Context;
import org.somda.sdc.glue.provider.sco.ScoController;
import org.somda.sdc.glue.provider.sco.factory.ContextFactory;
import org.somda.sdc.glue.provider.services.HighPriorityServices;
import org.somda.sdc.glue.provider.services.factory.ServicesFactory;
import org.somda.sdc.glue.provider.services.helper.ReportGenerator;
import org.somda.sdc.glue.provider.services.helper.factory.ReportGeneratorFactory;

public class DefaultGlueModule
extends AbstractModule {
    private ExecutorWrapperService<ListeningExecutorService> consumerExecutor = null;
    private ExecutorWrapperService<ScheduledExecutorService> watchdogScheduledExecutor = null;

    protected void configure() {
        this.configureCommon();
        this.configureConsumer();
        this.configureProvider();
    }

    private void configureCommon() {
        this.install(new FactoryModuleBuilder().implement(MdibMapper.class, MdibMapper.class).build(MdibMapperFactory.class));
        this.install(new FactoryModuleBuilder().implement(ModificationsBuilder.class, ModificationsBuilder.class).build(ModificationsBuilderFactory.class));
    }

    private void configureConsumer() {
        this.bind(SdcRemoteDevicesConnector.class).to(SdcRemoteDevicesConnectorImpl.class);
        this.install(new FactoryModuleBuilder().implement(OperationInvocationDispatcher.class, OperationInvocationDispatcher.class).build(OperationInvocationDispatcherFactory.class));
        this.install(new FactoryModuleBuilder().implement(SdcRemoteDevice.class, SdcRemoteDeviceImpl.class).build(SdcRemoteDeviceFactory.class));
        this.install(new FactoryModuleBuilder().implement(org.somda.sdc.glue.consumer.sco.ScoController.class, org.somda.sdc.glue.consumer.sco.ScoController.class).build(ScoControllerFactory.class));
        this.install(new FactoryModuleBuilder().implement(SdcRemoteDeviceWatchdog.class, SdcRemoteDeviceWatchdog.class).build(SdcRemoteDeviceWatchdogFactory.class));
        this.install(new FactoryModuleBuilder().implement(LocalizationServiceProxy.class, LocalizationServiceProxy.class).build(LocalizationServiceProxyFactory.class));
    }

    private void configureProvider() {
        this.install(new FactoryModuleBuilder().implement(ScoController.class, ScoController.class).build(org.somda.sdc.glue.provider.sco.factory.ScoControllerFactory.class));
        this.install(new FactoryModuleBuilder().implement(HighPriorityServices.class, HighPriorityServices.class).build(ServicesFactory.class));
        this.install(new FactoryModuleBuilder().implement(SdcDevice.class, SdcDevice.class).build(SdcDeviceFactory.class));
        this.install(new FactoryModuleBuilder().implement(Context.class, Context.class).build(ContextFactory.class));
        this.install(new FactoryModuleBuilder().implement(ReportGenerator.class, ReportGenerator.class).build(ReportGeneratorFactory.class));
        this.install(new FactoryModuleBuilder().implement(LocalizationService.class, LocalizationServiceImpl.class).build(LocalizationServiceFactory.class));
    }

    @Provides
    @Consumer
    ExecutorWrapperService<ListeningExecutorService> getConsumerExecutor(@Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        if (this.consumerExecutor == null) {
            Callable<ListeningExecutorService> executor = () -> MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(10, new ThreadFactoryBuilder().setNameFormat("Consumer-thread-%d").setDaemon(true).build()));
            this.consumerExecutor = new ExecutorWrapperService(executor, "Consumer", frameworkIdentifier);
        }
        return this.consumerExecutor;
    }

    @Provides
    @WatchdogScheduledExecutor
    ExecutorWrapperService<ScheduledExecutorService> getWatchdogScheduledExecutor(@Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        if (this.watchdogScheduledExecutor == null) {
            Callable<ScheduledExecutorService> executor = () -> Executors.newScheduledThreadPool(10, new ThreadFactoryBuilder().setNameFormat("WatchdogScheduledExecutor-thread-%d").setDaemon(true).build());
            this.watchdogScheduledExecutor = new ExecutorWrapperService(executor, "WatchdogScheduledExecutor", frameworkIdentifier);
        }
        return this.watchdogScheduledExecutor;
    }
}

