/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.glue.provider.helper;

import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.glue.provider.SdcDeviceContext;
import org.somda.sdc.glue.provider.SdcDevicePlugin;

public class SdcDevicePluginProcessor {
    private static final Logger LOG = LogManager.getLogger(SdcDevicePluginProcessor.class);
    private final SdcDeviceContext context;
    private final Collection<SdcDevicePlugin> devicePlugins;

    public SdcDevicePluginProcessor(Collection<SdcDevicePlugin> devicePlugins, SdcDeviceContext context) {
        this.context = context;
        this.devicePlugins = devicePlugins;
    }

    public void beforeStartUp() throws Exception {
        for (SdcDevicePlugin devicePlugin : this.devicePlugins) {
            try {
                devicePlugin.beforeStartUp(this.context);
            }
            catch (Exception e) {
                LOG.warn("Plugin {} has thrown an exception before start up: {}", (Object)devicePlugin, (Object)e.getMessage());
                LOG.trace("Plugin {} has thrown an exception before start up", (Object)devicePlugin, (Object)e);
                throw e;
            }
        }
    }

    public void afterStartUp() throws Exception {
        for (SdcDevicePlugin devicePlugin : this.devicePlugins) {
            try {
                devicePlugin.afterStartUp(this.context);
            }
            catch (Exception e) {
                LOG.warn("Plugin {} has thrown an exception after start up: {}", (Object)devicePlugin, (Object)e.getMessage());
                LOG.trace("Plugin {} has thrown an exception after start up", (Object)devicePlugin, (Object)e);
                throw e;
            }
        }
    }

    public void beforeShutDown() {
        for (SdcDevicePlugin devicePlugin : this.devicePlugins) {
            try {
                devicePlugin.beforeShutDown(this.context);
            }
            catch (Exception e) {
                LOG.warn("Plugin {} has thrown an exception before shut down: {}", (Object)devicePlugin, (Object)e.getMessage());
                LOG.trace("Plugin {} has thrown an exception before shut down", (Object)devicePlugin, (Object)e);
            }
        }
    }

    public void afterShutDown() {
        for (SdcDevicePlugin devicePlugin : this.devicePlugins) {
            try {
                devicePlugin.afterShutDown(this.context);
            }
            catch (Exception e) {
                LOG.warn("Plugin {} has thrown an exception after shut down: {}", (Object)devicePlugin, (Object)e.getMessage());
                LOG.trace("Plugin {} has thrown an exception after shut down", (Object)devicePlugin, (Object)e);
            }
        }
    }
}

