/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jaxb.runtime.v2.runtime.reflect;

import jakarta.xml.bind.JAXBException;
import org.glassfish.jaxb.runtime.api.AccessorException;
import org.glassfish.jaxb.runtime.v2.runtime.Transducer;
import org.glassfish.jaxb.runtime.v2.runtime.XMLSerializer;
import org.glassfish.jaxb.runtime.v2.runtime.reflect.Accessor;
import org.glassfish.jaxb.runtime.v2.runtime.reflect.DefaultTransducedAccessor;
import org.glassfish.jaxb.runtime.v2.runtime.reflect.ListIterator;
import org.glassfish.jaxb.runtime.v2.runtime.reflect.Lister;
import org.xml.sax.SAXException;

public final class ListTransducedAccessorImpl<BeanT, ListT, ItemT, PackT>
extends DefaultTransducedAccessor<BeanT> {
    private final Transducer<ItemT> xducer;
    private final Lister<BeanT, ListT, ItemT, PackT> lister;
    private final Accessor<BeanT, ListT> acc;

    public ListTransducedAccessorImpl(Transducer<ItemT> xducer, Accessor<BeanT, ListT> acc, Lister<BeanT, ListT, ItemT, PackT> lister) {
        this.xducer = xducer;
        this.lister = lister;
        this.acc = acc;
    }

    public boolean useNamespace() {
        return this.xducer.useNamespace();
    }

    public void declareNamespace(BeanT bean, XMLSerializer w) throws AccessorException, SAXException {
        Object list = this.acc.get(bean);
        if (list != null) {
            ListIterator itr = this.lister.iterator(list, w);
            while (itr.hasNext()) {
                try {
                    Object item = itr.next();
                    if (item == null) continue;
                    this.xducer.declareNamespace(item, w);
                }
                catch (JAXBException e) {
                    w.reportError(null, (Throwable)e);
                }
            }
        }
    }

    public String print(BeanT o) throws AccessorException, SAXException {
        Object list = this.acc.get(o);
        if (list == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        XMLSerializer w = XMLSerializer.getInstance();
        ListIterator itr = this.lister.iterator(list, w);
        while (itr.hasNext()) {
            try {
                Object item = itr.next();
                if (item == null) continue;
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(this.xducer.print(item));
            }
            catch (JAXBException e) {
                w.reportError(null, (Throwable)e);
            }
        }
        return buf.toString();
    }

    private void processValue(BeanT bean, CharSequence s) throws AccessorException, SAXException {
        Object pack = this.lister.startPacking(bean, this.acc);
        int idx = 0;
        int len = s.length();
        while (true) {
            int p;
            for (p = idx; p < len && !this.isSpace(Character.valueOf(s.charAt(p))); ++p) {
            }
            CharSequence token = s.subSequence(idx, p);
            if (!token.equals("")) {
                this.lister.addToPack(pack, this.xducer.parse(token));
            }
            if (p == len) break;
            while (p < len && this.isSpace(Character.valueOf(s.charAt(p)))) {
                ++p;
            }
            if (p == len) break;
            idx = p;
        }
        this.lister.endPacking(pack, bean, this.acc);
    }

    public void parse(BeanT bean, CharSequence lexical) throws AccessorException, SAXException {
        this.processValue(bean, lexical);
    }

    public boolean hasValue(BeanT bean) throws AccessorException {
        return this.acc.get(bean) != null;
    }

    private boolean isSpace(Character ch) {
        return ch.charValue() == ' ';
    }
}

