
package org.somda.sdc.mdpws.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.lang.CopyStrategy2;
import org.jvnet.jaxb2_commons.lang.CopyTo2;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;
import org.w3c.dom.Element;


/**
 * Assertion has [Message Policy Subject] or [Operation Policy Subject] or [Endpoint Policy Subject]. When present in a policy alternative, it indicates that for the subject additional safety information need to be transmitted for the specified message elements.
 * 
 * <p>Java class for SafetyReqAssertionType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="SafetyReqAssertionType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;any processContents='skip' namespace='##other' maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="TransmitDualChannel" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" /&gt;
 *       &lt;attribute name="TransmitSafetyContext" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" /&gt;
 *       &lt;anyAttribute processContents='skip' namespace='##other'/&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SafetyReqAssertionType", namespace = "http://standards.ieee.org/downloads/11073/11073-20702-2016", propOrder = {
    "any"
})
public class SafetyRequirementsAssertionType implements Cloneable, CopyTo2, ToString2
{

    @XmlAnyElement
    protected List<Element> any;
    @XmlAttribute(name = "TransmitDualChannel")
    protected Boolean transmitDualChannel;
    @XmlAttribute(name = "TransmitSafetyContext")
    protected Boolean transmitSafetyContext;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    /**
     * Gets the value of the any property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the any property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAny().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Element }
     * 
     * 
     */
    public List<Element> getAny() {
        if (any == null) {
            any = new ArrayList<Element>();
        }
        return this.any;
    }

    /**
     * Ruft den Wert der transmitDualChannel-Eigenschaft ab.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isTransmitDualChannel() {
        if (transmitDualChannel == null) {
            return true;
        } else {
            return transmitDualChannel;
        }
    }

    /**
     * Legt den Wert der transmitDualChannel-Eigenschaft fest.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setTransmitDualChannel(Boolean value) {
        this.transmitDualChannel = value;
    }

    /**
     * Ruft den Wert der transmitSafetyContext-Eigenschaft ab.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isTransmitSafetyContext() {
        if (transmitSafetyContext == null) {
            return true;
        } else {
            return transmitSafetyContext;
        }
    }

    /**
     * Legt den Wert der transmitSafetyContext-Eigenschaft fest.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setTransmitSafetyContext(Boolean value) {
        this.transmitSafetyContext = value;
    }

    /**
     * Gets a map that contains attributes that aren't bound to any typed property on this class.
     * 
     * <p>
     * the map is keyed by the name of the attribute and 
     * the value is the string value of the attribute.
     * 
     * the map returned by this method is live, and you can add new attribute
     * by updating the map directly. Because of this design, there's no setter.
     * 
     * 
     * @return
     *     always non-null
     */
    public Map<QName, String> getOtherAttributes() {
        return otherAttributes;
    }

    public void setAny(List<Element> value) {
        this.any = null;
        if (value!= null) {
            List<Element> draftl = this.getAny();
            draftl.addAll(value);
        }
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy2 strategy = JAXBCopyStrategy.INSTANCE2;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy2 strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof SafetyRequirementsAssertionType) {
            final SafetyRequirementsAssertionType copy = ((SafetyRequirementsAssertionType) draftCopy);
            {
                Boolean anyShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, ((this.any!= null)&&(!this.any.isEmpty())));
                if (anyShouldBeCopiedAndSet == Boolean.TRUE) {
                    List<Element> sourceAny;
                    sourceAny = (((this.any!= null)&&(!this.any.isEmpty()))?this.getAny():null);
                    @SuppressWarnings("unchecked")
                    List<Element> copyAny = ((List<Element> ) strategy.copy(LocatorUtils.property(locator, "any", sourceAny), sourceAny, ((this.any!= null)&&(!this.any.isEmpty()))));
                    copy.setAny(copyAny);
                } else {
                    if (anyShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.any = null;
                    }
                }
            }
            {
                Boolean transmitDualChannelShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.transmitDualChannel!= null));
                if (transmitDualChannelShouldBeCopiedAndSet == Boolean.TRUE) {
                    boolean sourceTransmitDualChannel;
                    sourceTransmitDualChannel = ((this.transmitDualChannel!= null)?this.isTransmitDualChannel():true);
                    boolean copyTransmitDualChannel = strategy.copy(LocatorUtils.property(locator, "transmitDualChannel", sourceTransmitDualChannel), sourceTransmitDualChannel, (this.transmitDualChannel!= null));
                    copy.setTransmitDualChannel(copyTransmitDualChannel);
                } else {
                    if (transmitDualChannelShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.transmitDualChannel = null;
                    }
                }
            }
            {
                Boolean transmitSafetyContextShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.transmitSafetyContext!= null));
                if (transmitSafetyContextShouldBeCopiedAndSet == Boolean.TRUE) {
                    boolean sourceTransmitSafetyContext;
                    sourceTransmitSafetyContext = ((this.transmitSafetyContext!= null)?this.isTransmitSafetyContext():true);
                    boolean copyTransmitSafetyContext = strategy.copy(LocatorUtils.property(locator, "transmitSafetyContext", sourceTransmitSafetyContext), sourceTransmitSafetyContext, (this.transmitSafetyContext!= null));
                    copy.setTransmitSafetyContext(copyTransmitSafetyContext);
                } else {
                    if (transmitSafetyContextShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.transmitSafetyContext = null;
                    }
                }
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new SafetyRequirementsAssertionType();
    }

    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final SafetyRequirementsAssertionType that = ((SafetyRequirementsAssertionType) object);
        {
            List<Element> leftAny;
            leftAny = (((this.any!= null)&&(!this.any.isEmpty()))?this.getAny():null);
            List<Element> rightAny;
            rightAny = (((that.any!= null)&&(!that.any.isEmpty()))?that.getAny():null);
            if ((this.any!= null)&&(!this.any.isEmpty())) {
                if ((that.any!= null)&&(!that.any.isEmpty())) {
                    if (!leftAny.equals(rightAny)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.any!= null)&&(!that.any.isEmpty())) {
                    return false;
                }
            }
        }
        {
            boolean leftTransmitDualChannel;
            leftTransmitDualChannel = ((this.transmitDualChannel!= null)?this.isTransmitDualChannel():true);
            boolean rightTransmitDualChannel;
            rightTransmitDualChannel = ((that.transmitDualChannel!= null)?that.isTransmitDualChannel():true);
            if (this.transmitDualChannel!= null) {
                if (that.transmitDualChannel!= null) {
                    if (leftTransmitDualChannel!= rightTransmitDualChannel) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.transmitDualChannel!= null) {
                    return false;
                }
            }
        }
        {
            boolean leftTransmitSafetyContext;
            leftTransmitSafetyContext = ((this.transmitSafetyContext!= null)?this.isTransmitSafetyContext():true);
            boolean rightTransmitSafetyContext;
            rightTransmitSafetyContext = ((that.transmitSafetyContext!= null)?that.isTransmitSafetyContext():true);
            if (this.transmitSafetyContext!= null) {
                if (that.transmitSafetyContext!= null) {
                    if (leftTransmitSafetyContext!= rightTransmitSafetyContext) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.transmitSafetyContext!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            List<Element> theAny;
            theAny = (((this.any!= null)&&(!this.any.isEmpty()))?this.getAny():null);
            if ((this.any!= null)&&(!this.any.isEmpty())) {
                currentHashCode += theAny.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            boolean theTransmitDualChannel;
            theTransmitDualChannel = ((this.transmitDualChannel!= null)?this.isTransmitDualChannel():true);
            if (this.transmitDualChannel!= null) {
                currentHashCode += (theTransmitDualChannel? 1231 : 1237);
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            boolean theTransmitSafetyContext;
            theTransmitSafetyContext = ((this.transmitSafetyContext!= null)?this.isTransmitSafetyContext():true);
            if (this.transmitSafetyContext!= null) {
                currentHashCode += (theTransmitSafetyContext? 1231 : 1237);
            }
        }
        return currentHashCode;
    }

    public String toString() {
        final ToStringStrategy2 strategy = JAXBToStringStrategy.INSTANCE2;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        {
            List<Element> theAny;
            theAny = (((this.any!= null)&&(!this.any.isEmpty()))?this.getAny():null);
            strategy.appendField(locator, this, "any", buffer, theAny, ((this.any!= null)&&(!this.any.isEmpty())));
        }
        {
            boolean theTransmitDualChannel;
            theTransmitDualChannel = ((this.transmitDualChannel!= null)?this.isTransmitDualChannel():true);
            strategy.appendField(locator, this, "transmitDualChannel", buffer, theTransmitDualChannel, (this.transmitDualChannel!= null));
        }
        {
            boolean theTransmitSafetyContext;
            theTransmitSafetyContext = ((this.transmitSafetyContext!= null)?this.isTransmitSafetyContext():true);
            strategy.appendField(locator, this, "transmitSafetyContext", buffer, theTransmitSafetyContext, (this.transmitSafetyContext!= null));
        }
        return buffer;
    }

}
