
package org.somda.sdc.mdpws.model;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.lang.CopyStrategy2;
import org.jvnet.jaxb2_commons.lang.CopyTo2;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * Definition of the mechanisms that are utilized to transmit a stream.
 * 
 * <p>Java class for StreamTransmissionType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="StreamTransmissionType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="StreamAddress" type="{http://www.w3.org/2001/XMLSchema}anyURI" minOccurs="0"/&gt;
 *         &lt;element name="StreamPeriod" type="{http://www.w3.org/2001/XMLSchema}duration" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="Type" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&gt;
 *       &lt;anyAttribute processContents='skip' namespace='##other'/&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "StreamTransmissionType", namespace = "http://standards.ieee.org/downloads/11073/11073-20702-2016", propOrder = {
    "streamAddress",
    "streamPeriod"
})
public class StreamTransmissionType implements Cloneable, CopyTo2, ToString2
{

    @XmlElement(name = "StreamAddress", namespace = "http://standards.ieee.org/downloads/11073/11073-20702-2016")
    @XmlSchemaType(name = "anyURI")
    protected String streamAddress;
    @XmlElement(name = "StreamPeriod", namespace = "http://standards.ieee.org/downloads/11073/11073-20702-2016")
    protected Duration streamPeriod;
    @XmlAttribute(name = "Type")
    @XmlSchemaType(name = "anyURI")
    protected String type;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    /**
     * Ruft den Wert der streamAddress-Eigenschaft ab.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getStreamAddress() {
        return streamAddress;
    }

    /**
     * Legt den Wert der streamAddress-Eigenschaft fest.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setStreamAddress(String value) {
        this.streamAddress = value;
    }

    /**
     * Ruft den Wert der streamPeriod-Eigenschaft ab.
     * 
     * @return
     *     possible object is
     *     {@link Duration }
     *     
     */
    public Duration getStreamPeriod() {
        return streamPeriod;
    }

    /**
     * Legt den Wert der streamPeriod-Eigenschaft fest.
     * 
     * @param value
     *     allowed object is
     *     {@link Duration }
     *     
     */
    public void setStreamPeriod(Duration value) {
        this.streamPeriod = value;
    }

    /**
     * Ruft den Wert der type-Eigenschaft ab.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getType() {
        return type;
    }

    /**
     * Legt den Wert der type-Eigenschaft fest.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setType(String value) {
        this.type = value;
    }

    /**
     * Gets a map that contains attributes that aren't bound to any typed property on this class.
     * 
     * <p>
     * the map is keyed by the name of the attribute and 
     * the value is the string value of the attribute.
     * 
     * the map returned by this method is live, and you can add new attribute
     * by updating the map directly. Because of this design, there's no setter.
     * 
     * 
     * @return
     *     always non-null
     */
    public Map<QName, String> getOtherAttributes() {
        return otherAttributes;
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy2 strategy = JAXBCopyStrategy.INSTANCE2;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy2 strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof StreamTransmissionType) {
            final StreamTransmissionType copy = ((StreamTransmissionType) draftCopy);
            {
                Boolean streamAddressShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.streamAddress!= null));
                if (streamAddressShouldBeCopiedAndSet == Boolean.TRUE) {
                    String sourceStreamAddress;
                    sourceStreamAddress = this.getStreamAddress();
                    String copyStreamAddress = ((String) strategy.copy(LocatorUtils.property(locator, "streamAddress", sourceStreamAddress), sourceStreamAddress, (this.streamAddress!= null)));
                    copy.setStreamAddress(copyStreamAddress);
                } else {
                    if (streamAddressShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.streamAddress = null;
                    }
                }
            }
            {
                Boolean streamPeriodShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.streamPeriod!= null));
                if (streamPeriodShouldBeCopiedAndSet == Boolean.TRUE) {
                    Duration sourceStreamPeriod;
                    sourceStreamPeriod = this.getStreamPeriod();
                    Duration copyStreamPeriod = ((Duration) strategy.copy(LocatorUtils.property(locator, "streamPeriod", sourceStreamPeriod), sourceStreamPeriod, (this.streamPeriod!= null)));
                    copy.setStreamPeriod(copyStreamPeriod);
                } else {
                    if (streamPeriodShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.streamPeriod = null;
                    }
                }
            }
            {
                Boolean typeShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.type!= null));
                if (typeShouldBeCopiedAndSet == Boolean.TRUE) {
                    String sourceType;
                    sourceType = this.getType();
                    String copyType = ((String) strategy.copy(LocatorUtils.property(locator, "type", sourceType), sourceType, (this.type!= null)));
                    copy.setType(copyType);
                } else {
                    if (typeShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.type = null;
                    }
                }
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new StreamTransmissionType();
    }

    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final StreamTransmissionType that = ((StreamTransmissionType) object);
        {
            String leftStreamAddress;
            leftStreamAddress = this.getStreamAddress();
            String rightStreamAddress;
            rightStreamAddress = that.getStreamAddress();
            if (this.streamAddress!= null) {
                if (that.streamAddress!= null) {
                    if (!leftStreamAddress.equals(rightStreamAddress)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.streamAddress!= null) {
                    return false;
                }
            }
        }
        {
            Duration leftStreamPeriod;
            leftStreamPeriod = this.getStreamPeriod();
            Duration rightStreamPeriod;
            rightStreamPeriod = that.getStreamPeriod();
            if (this.streamPeriod!= null) {
                if (that.streamPeriod!= null) {
                    if (!leftStreamPeriod.equals(rightStreamPeriod)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.streamPeriod!= null) {
                    return false;
                }
            }
        }
        {
            String leftType;
            leftType = this.getType();
            String rightType;
            rightType = that.getType();
            if (this.type!= null) {
                if (that.type!= null) {
                    if (!leftType.equals(rightType)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.type!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theStreamAddress;
            theStreamAddress = this.getStreamAddress();
            if (this.streamAddress!= null) {
                currentHashCode += theStreamAddress.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Duration theStreamPeriod;
            theStreamPeriod = this.getStreamPeriod();
            if (this.streamPeriod!= null) {
                currentHashCode += theStreamPeriod.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theType;
            theType = this.getType();
            if (this.type!= null) {
                currentHashCode += theType.hashCode();
            }
        }
        return currentHashCode;
    }

    public String toString() {
        final ToStringStrategy2 strategy = JAXBToStringStrategy.INSTANCE2;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        {
            String theStreamAddress;
            theStreamAddress = this.getStreamAddress();
            strategy.appendField(locator, this, "streamAddress", buffer, theStreamAddress, (this.streamAddress!= null));
        }
        {
            Duration theStreamPeriod;
            theStreamPeriod = this.getStreamPeriod();
            strategy.appendField(locator, this, "streamPeriod", buffer, theStreamPeriod, (this.streamPeriod!= null));
        }
        {
            String theType;
            theType = this.getType();
            strategy.appendField(locator, this, "type", buffer, theType, (this.type!= null));
        }
        return buffer;
    }

}
