
package org.somda.sdc.mdpws.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.lang.CopyStrategy2;
import org.jvnet.jaxb2_commons.lang.CopyTo2;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;
import org.w3c.dom.Element;


/**
 * Defines a list of selectors that point to elements which are required to be protected by a dual-channel. The selector's root is SOAP message's body element.
 * 
 * <p>Java class for DualChannelDefType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="DualChannelDefType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="Selector" type="{http://standards.ieee.org/downloads/11073/11073-20702-2016}SelectorType" maxOccurs="unbounded"/&gt;
 *         &lt;any processContents='skip' namespace='##other' maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="Algorithm" type="{http://www.w3.org/2001/XMLSchema}QName" /&gt;
 *       &lt;attribute name="Transform" type="{http://www.w3.org/2001/XMLSchema}QName" /&gt;
 *       &lt;anyAttribute processContents='skip' namespace='##other'/&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DualChannelDefType", namespace = "http://standards.ieee.org/downloads/11073/11073-20702-2016", propOrder = {
    "selector",
    "any"
})
public class DualChannelDefinitionType implements Cloneable, CopyTo2, ToString2
{

    @XmlElement(name = "Selector", namespace = "http://standards.ieee.org/downloads/11073/11073-20702-2016", required = true)
    protected List<SelectorType> selector;
    @XmlAnyElement
    protected List<Element> any;
    @XmlAttribute(name = "Algorithm")
    protected QName algorithm;
    @XmlAttribute(name = "Transform")
    protected QName transform;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    /**
     * Gets the value of the selector property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the selector property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSelector().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SelectorType }
     * 
     * 
     */
    public List<SelectorType> getSelector() {
        if (selector == null) {
            selector = new ArrayList<SelectorType>();
        }
        return this.selector;
    }

    /**
     * Gets the value of the any property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the any property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAny().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Element }
     * 
     * 
     */
    public List<Element> getAny() {
        if (any == null) {
            any = new ArrayList<Element>();
        }
        return this.any;
    }

    /**
     * Gets the value of the algorithm property.
     * 
     * @return
     *     possible object is
     *     {@link QName }
     *     
     */
    public QName getAlgorithm() {
        return algorithm;
    }

    /**
     * Sets the value of the algorithm property.
     * 
     * @param value
     *     allowed object is
     *     {@link QName }
     *     
     */
    public void setAlgorithm(QName value) {
        this.algorithm = value;
    }

    /**
     * Gets the value of the transform property.
     * 
     * @return
     *     possible object is
     *     {@link QName }
     *     
     */
    public QName getTransform() {
        return transform;
    }

    /**
     * Sets the value of the transform property.
     * 
     * @param value
     *     allowed object is
     *     {@link QName }
     *     
     */
    public void setTransform(QName value) {
        this.transform = value;
    }

    /**
     * Gets a map that contains attributes that aren't bound to any typed property on this class.
     * 
     * <p>
     * the map is keyed by the name of the attribute and 
     * the value is the string value of the attribute.
     * 
     * the map returned by this method is live, and you can add new attribute
     * by updating the map directly. Because of this design, there's no setter.
     * 
     * 
     * @return
     *     always non-null
     */
    public Map<QName, String> getOtherAttributes() {
        return otherAttributes;
    }

    public void setSelector(List<SelectorType> value) {
        this.selector = null;
        if (value!= null) {
            List<SelectorType> draftl = this.getSelector();
            draftl.addAll(value);
        }
    }

    public void setAny(List<Element> value) {
        this.any = null;
        if (value!= null) {
            List<Element> draftl = this.getAny();
            draftl.addAll(value);
        }
    }

    @Override
    public Object clone() {
        return copyTo(createNewInstance());
    }

    @Override
    public Object copyTo(Object target) {
        final CopyStrategy2 strategy = JAXBCopyStrategy.getInstance();
        return copyTo(null, target, strategy);
    }

    @Override
    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy2 strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof DualChannelDefinitionType) {
            final DualChannelDefinitionType copy = ((DualChannelDefinitionType) draftCopy);
            {
                Boolean selectorShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, ((this.selector!= null)&&(!this.selector.isEmpty())));
                if (selectorShouldBeCopiedAndSet == Boolean.TRUE) {
                    List<SelectorType> sourceSelector;
                    sourceSelector = (((this.selector!= null)&&(!this.selector.isEmpty()))?this.getSelector():null);
                    @SuppressWarnings("unchecked")
                    List<SelectorType> copySelector = ((List<SelectorType> ) strategy.copy(LocatorUtils.property(locator, "selector", sourceSelector), sourceSelector, ((this.selector!= null)&&(!this.selector.isEmpty()))));
                    copy.setSelector(copySelector);
                } else {
                    if (selectorShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.selector = null;
                    }
                }
            }
            {
                Boolean anyShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, ((this.any!= null)&&(!this.any.isEmpty())));
                if (anyShouldBeCopiedAndSet == Boolean.TRUE) {
                    List<Element> sourceAny;
                    sourceAny = (((this.any!= null)&&(!this.any.isEmpty()))?this.getAny():null);
                    @SuppressWarnings("unchecked")
                    List<Element> copyAny = ((List<Element> ) strategy.copy(LocatorUtils.property(locator, "any", sourceAny), sourceAny, ((this.any!= null)&&(!this.any.isEmpty()))));
                    copy.setAny(copyAny);
                } else {
                    if (anyShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.any = null;
                    }
                }
            }
            {
                Boolean algorithmShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.algorithm!= null));
                if (algorithmShouldBeCopiedAndSet == Boolean.TRUE) {
                    QName sourceAlgorithm;
                    sourceAlgorithm = this.getAlgorithm();
                    QName copyAlgorithm = ((QName) strategy.copy(LocatorUtils.property(locator, "algorithm", sourceAlgorithm), sourceAlgorithm, (this.algorithm!= null)));
                    copy.setAlgorithm(copyAlgorithm);
                } else {
                    if (algorithmShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.algorithm = null;
                    }
                }
            }
            {
                Boolean transformShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.transform!= null));
                if (transformShouldBeCopiedAndSet == Boolean.TRUE) {
                    QName sourceTransform;
                    sourceTransform = this.getTransform();
                    QName copyTransform = ((QName) strategy.copy(LocatorUtils.property(locator, "transform", sourceTransform), sourceTransform, (this.transform!= null)));
                    copy.setTransform(copyTransform);
                } else {
                    if (transformShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.transform = null;
                    }
                }
            }
        }
        return draftCopy;
    }

    @Override
    public Object createNewInstance() {
        return new DualChannelDefinitionType();
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final DualChannelDefinitionType that = ((DualChannelDefinitionType) object);
        {
            List<SelectorType> leftSelector;
            leftSelector = (((this.selector!= null)&&(!this.selector.isEmpty()))?this.getSelector():null);
            List<SelectorType> rightSelector;
            rightSelector = (((that.selector!= null)&&(!that.selector.isEmpty()))?that.getSelector():null);
            if ((this.selector!= null)&&(!this.selector.isEmpty())) {
                if ((that.selector!= null)&&(!that.selector.isEmpty())) {
                    if (!leftSelector.equals(rightSelector)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.selector!= null)&&(!that.selector.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<Element> leftAny;
            leftAny = (((this.any!= null)&&(!this.any.isEmpty()))?this.getAny():null);
            List<Element> rightAny;
            rightAny = (((that.any!= null)&&(!that.any.isEmpty()))?that.getAny():null);
            if ((this.any!= null)&&(!this.any.isEmpty())) {
                if ((that.any!= null)&&(!that.any.isEmpty())) {
                    if (!leftAny.equals(rightAny)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.any!= null)&&(!that.any.isEmpty())) {
                    return false;
                }
            }
        }
        {
            QName leftAlgorithm;
            leftAlgorithm = this.getAlgorithm();
            QName rightAlgorithm;
            rightAlgorithm = that.getAlgorithm();
            if (this.algorithm!= null) {
                if (that.algorithm!= null) {
                    if (!leftAlgorithm.equals(rightAlgorithm)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.algorithm!= null) {
                    return false;
                }
            }
        }
        {
            QName leftTransform;
            leftTransform = this.getTransform();
            QName rightTransform;
            rightTransform = that.getTransform();
            if (this.transform!= null) {
                if (that.transform!= null) {
                    if (!leftTransform.equals(rightTransform)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.transform!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            List<SelectorType> theSelector;
            theSelector = (((this.selector!= null)&&(!this.selector.isEmpty()))?this.getSelector():null);
            if ((this.selector!= null)&&(!this.selector.isEmpty())) {
                currentHashCode += theSelector.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<Element> theAny;
            theAny = (((this.any!= null)&&(!this.any.isEmpty()))?this.getAny():null);
            if ((this.any!= null)&&(!this.any.isEmpty())) {
                currentHashCode += theAny.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            QName theAlgorithm;
            theAlgorithm = this.getAlgorithm();
            if (this.algorithm!= null) {
                currentHashCode += theAlgorithm.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            QName theTransform;
            theTransform = this.getTransform();
            if (this.transform!= null) {
                currentHashCode += theTransform.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        final ToStringStrategy2 strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        {
            List<SelectorType> theSelector;
            theSelector = (((this.selector!= null)&&(!this.selector.isEmpty()))?this.getSelector():null);
            strategy.appendField(locator, this, "selector", buffer, theSelector, ((this.selector!= null)&&(!this.selector.isEmpty())));
        }
        {
            List<Element> theAny;
            theAny = (((this.any!= null)&&(!this.any.isEmpty()))?this.getAny():null);
            strategy.appendField(locator, this, "any", buffer, theAny, ((this.any!= null)&&(!this.any.isEmpty())));
        }
        {
            QName theAlgorithm;
            theAlgorithm = this.getAlgorithm();
            strategy.appendField(locator, this, "algorithm", buffer, theAlgorithm, (this.algorithm!= null));
        }
        {
            QName theTransform;
            theTransform = this.getTransform();
            strategy.appendField(locator, this, "transform", buffer, theTransform, (this.transform!= null));
        }
        return buffer;
    }

}
