
package org.somda.sdc.mpkp.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.CopyStrategy;
import org.jvnet.jaxb.lang.CopyTo;
import org.jvnet.jaxb.lang.JAXBCopyStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Type definition for the DisplayedBy element.
 * 
 * <p>Java class for DisplayedByType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="DisplayedByType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="ReferencedMetric" type="{http://standards.ieee.org/downloads/11073/11073-10207-2017/participant}HandleRef" />
 *       <attribute ref="{http://standards.ieee.org/downloads/11073/11073-10207-2017/extension}MustUnderstand"/>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DisplayedByType", namespace = "urn:oid:1.3.111.2.11073.10701.3.1.1")
public class DisplayedByType implements Cloneable, CopyTo, ToString
{

    /**
     * Handle reference of the METRIC that provides display data. If ReferencedMetric is not present, it is unknown to the SDC METRIC PROVIDER which data is actually being displayed.
     * 
     */
    @XmlAttribute(name = "ReferencedMetric")
    protected String referencedMetric;
    /**
     * In cases where an extension modifies the meaning of the element that contains it, a MustUnderstand attribute is senseful. This means that the data cannot safely be processed unless the application knows the meaning of the extension. A MustUnderstand marked extension could be look like this:
     * 
     * tns:Extension xmlns:tns="http://standards.ieee.org/downloads/11073/11073-10207-2017/extension" xmlns:ext="http://concrete-extension-namespace"
     *   ext:AdditionalInfo tns:MustUnderstand="true"
     *     ...
     * 
     * 
     * Extensions are not required to provide a MustUnderstand attribute. If no MustUnderstand attribute is present, false is assumed. The MustUnderstand attribute is conceptually borrowed from SOAP header's "mustUnderstand" attribute.
     * 
     */
    @XmlAttribute(name = "MustUnderstand", namespace = "http://standards.ieee.org/downloads/11073/11073-10207-2017/extension")
    protected Boolean mustUnderstand;

    /**
     * Handle reference of the METRIC that provides display data. If ReferencedMetric is not present, it is unknown to the SDC METRIC PROVIDER which data is actually being displayed.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getReferencedMetric() {
        return referencedMetric;
    }

    /**
     * Sets the value of the referencedMetric property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getReferencedMetric()
     */
    public void setReferencedMetric(String value) {
        this.referencedMetric = value;
    }

    /**
     * In cases where an extension modifies the meaning of the element that contains it, a MustUnderstand attribute is senseful. This means that the data cannot safely be processed unless the application knows the meaning of the extension. A MustUnderstand marked extension could be look like this:
     * 
     * tns:Extension xmlns:tns="http://standards.ieee.org/downloads/11073/11073-10207-2017/extension" xmlns:ext="http://concrete-extension-namespace"
     *   ext:AdditionalInfo tns:MustUnderstand="true"
     *     ...
     * 
     * 
     * Extensions are not required to provide a MustUnderstand attribute. If no MustUnderstand attribute is present, false is assumed. The MustUnderstand attribute is conceptually borrowed from SOAP header's "mustUnderstand" attribute.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isMustUnderstand() {
        if (mustUnderstand == null) {
            return false;
        } else {
            return mustUnderstand;
        }
    }

    /**
     * Sets the value of the mustUnderstand property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isMustUnderstand()
     */
    public void setMustUnderstand(Boolean value) {
        this.mustUnderstand = value;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final DisplayedByType that = ((DisplayedByType) object);
        {
            String leftReferencedMetric;
            leftReferencedMetric = this.getReferencedMetric();
            String rightReferencedMetric;
            rightReferencedMetric = that.getReferencedMetric();
            if (this.referencedMetric!= null) {
                if (that.referencedMetric!= null) {
                    if (!leftReferencedMetric.equals(rightReferencedMetric)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.referencedMetric!= null) {
                    return false;
                }
            }
        }
        {
            boolean leftMustUnderstand;
            leftMustUnderstand = ((this.mustUnderstand!= null)?this.isMustUnderstand():false);
            boolean rightMustUnderstand;
            rightMustUnderstand = ((that.mustUnderstand!= null)?that.isMustUnderstand():false);
            if (this.mustUnderstand!= null) {
                if (that.mustUnderstand!= null) {
                    if (leftMustUnderstand!= rightMustUnderstand) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.mustUnderstand!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theReferencedMetric;
            theReferencedMetric = this.getReferencedMetric();
            if (this.referencedMetric!= null) {
                currentHashCode += theReferencedMetric.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            boolean theMustUnderstand;
            theMustUnderstand = ((this.mustUnderstand!= null)?this.isMustUnderstand():false);
            if (this.mustUnderstand!= null) {
                currentHashCode += (theMustUnderstand? 1231 : 1237);
            }
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theReferencedMetric;
            theReferencedMetric = this.getReferencedMetric();
            strategy.appendField(locator, this, "referencedMetric", buffer, theReferencedMetric, (this.referencedMetric!= null));
        }
        {
            boolean theMustUnderstand;
            theMustUnderstand = ((this.mustUnderstand!= null)?this.isMustUnderstand():false);
            strategy.appendField(locator, this, "mustUnderstand", buffer, theMustUnderstand, (this.mustUnderstand!= null));
        }
        return buffer;
    }

    @Override
    public Object clone() {
        return copyTo(createNewInstance());
    }

    @Override
    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.getInstance();
        return copyTo(null, target, strategy);
    }

    @Override
    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof DisplayedByType) {
            final DisplayedByType copy = ((DisplayedByType) draftCopy);
            {
                Boolean referencedMetricShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.referencedMetric!= null));
                if (referencedMetricShouldBeCopiedAndSet == Boolean.TRUE) {
                    String sourceReferencedMetric;
                    sourceReferencedMetric = this.getReferencedMetric();
                    String copyReferencedMetric = ((String) strategy.copy(LocatorUtils.property(locator, "referencedMetric", sourceReferencedMetric), sourceReferencedMetric, (this.referencedMetric!= null)));
                    copy.setReferencedMetric(copyReferencedMetric);
                } else {
                    if (referencedMetricShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.referencedMetric = null;
                    }
                }
            }
            {
                Boolean mustUnderstandShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.mustUnderstand!= null));
                if (mustUnderstandShouldBeCopiedAndSet == Boolean.TRUE) {
                    boolean sourceMustUnderstand;
                    sourceMustUnderstand = ((this.mustUnderstand!= null)?this.isMustUnderstand():false);
                    boolean copyMustUnderstand = strategy.copy(LocatorUtils.property(locator, "mustUnderstand", sourceMustUnderstand), sourceMustUnderstand, (this.mustUnderstand!= null));
                    copy.setMustUnderstand(copyMustUnderstand);
                } else {
                    if (mustUnderstandShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.mustUnderstand = null;
                    }
                }
            }
        }
        return draftCopy;
    }

    @Override
    public Object createNewInstance() {
        return new DisplayedByType();
    }

}
