
package org.somda.sdpi.model;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.CopyStrategy;
import org.jvnet.jaxb.lang.CopyTo;
import org.jvnet.jaxb.lang.JAXBCopyStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * <p>Java class for CodedAttributesType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="CodedAttributesType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oid:1.3.6.1.4.1.19376.1.6.2.10.1.1.1}CodedStringAttribute" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oid:1.3.6.1.4.1.19376.1.6.2.10.1.1.1}CodedIntegerAttribute" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oid:1.3.6.1.4.1.19376.1.6.2.10.1.1.1}CodedDecimalAttribute" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute ref="{http://standards.ieee.org/downloads/11073/11073-10207-2017/extension}MustUnderstand"/>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CodedAttributesType", namespace = "urn:oid:1.3.6.1.4.1.19376.1.6.2.10.1.1.1", propOrder = {
    "codedStringAttribute",
    "codedIntegerAttribute",
    "codedDecimalAttribute"
})
public class CodedAttributesType implements Cloneable, CopyTo, ToString
{

    /**
     * A key value pair to include string attributes of the IEEE 11073 classic domain information model that are not available from the BICEPS participant model.
     * 
     */
    @XmlElement(name = "CodedStringAttribute", namespace = "urn:oid:1.3.6.1.4.1.19376.1.6.2.10.1.1.1")
    protected List<CodedStringAttributeType> codedStringAttribute;
    /**
     * A key value pair to include integer attributes of the IEEE 11073 classic domain information model that are not available from the BICEPS participant model.
     * 
     */
    @XmlElement(name = "CodedIntegerAttribute", namespace = "urn:oid:1.3.6.1.4.1.19376.1.6.2.10.1.1.1")
    protected List<CodedIntegerAttributeType> codedIntegerAttribute;
    /**
     * A key value pair to include decimal attributes of the IEEE 11073 classic domain information model that are not available from the BICEPS participant model.
     * 
     */
    @XmlElement(name = "CodedDecimalAttribute", namespace = "urn:oid:1.3.6.1.4.1.19376.1.6.2.10.1.1.1")
    protected List<CodedDecimalAttributeType> codedDecimalAttribute;
    /**
     * In cases where an extension modifies the meaning of the element that contains it, a MustUnderstand attribute is senseful. This means that the data cannot safely be processed unless the application knows the meaning of the extension. A MustUnderstand marked extension could be look like this:
     * 
     * tns:Extension xmlns:tns="http://standards.ieee.org/downloads/11073/11073-10207-2017/extension" xmlns:ext="http://concrete-extension-namespace"
     *   ext:AdditionalInfo tns:MustUnderstand="true"
     *     ...
     * 
     * 
     * Extensions are not required to provide a MustUnderstand attribute. If no MustUnderstand attribute is present, false is assumed. The MustUnderstand attribute is conceptually borrowed from SOAP header's "mustUnderstand" attribute.
     * 
     */
    @XmlAttribute(name = "MustUnderstand", namespace = "http://standards.ieee.org/downloads/11073/11073-10207-2017/extension")
    protected Boolean mustUnderstand;

    /**
     * A key value pair to include string attributes of the IEEE 11073 classic domain information model that are not available from the BICEPS participant model.
     * 
     * Gets the value of the codedStringAttribute property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the codedStringAttribute property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCodedStringAttribute().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodedStringAttributeType }
     * </p>
     * 
     * 
     * @return
     *     The value of the codedStringAttribute property.
     */
    public List<CodedStringAttributeType> getCodedStringAttribute() {
        if (codedStringAttribute == null) {
            codedStringAttribute = new ArrayList<>();
        }
        return this.codedStringAttribute;
    }

    /**
     * A key value pair to include integer attributes of the IEEE 11073 classic domain information model that are not available from the BICEPS participant model.
     * 
     * Gets the value of the codedIntegerAttribute property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the codedIntegerAttribute property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCodedIntegerAttribute().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodedIntegerAttributeType }
     * </p>
     * 
     * 
     * @return
     *     The value of the codedIntegerAttribute property.
     */
    public List<CodedIntegerAttributeType> getCodedIntegerAttribute() {
        if (codedIntegerAttribute == null) {
            codedIntegerAttribute = new ArrayList<>();
        }
        return this.codedIntegerAttribute;
    }

    /**
     * A key value pair to include decimal attributes of the IEEE 11073 classic domain information model that are not available from the BICEPS participant model.
     * 
     * Gets the value of the codedDecimalAttribute property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the codedDecimalAttribute property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCodedDecimalAttribute().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodedDecimalAttributeType }
     * </p>
     * 
     * 
     * @return
     *     The value of the codedDecimalAttribute property.
     */
    public List<CodedDecimalAttributeType> getCodedDecimalAttribute() {
        if (codedDecimalAttribute == null) {
            codedDecimalAttribute = new ArrayList<>();
        }
        return this.codedDecimalAttribute;
    }

    /**
     * In cases where an extension modifies the meaning of the element that contains it, a MustUnderstand attribute is senseful. This means that the data cannot safely be processed unless the application knows the meaning of the extension. A MustUnderstand marked extension could be look like this:
     * 
     * tns:Extension xmlns:tns="http://standards.ieee.org/downloads/11073/11073-10207-2017/extension" xmlns:ext="http://concrete-extension-namespace"
     *   ext:AdditionalInfo tns:MustUnderstand="true"
     *     ...
     * 
     * 
     * Extensions are not required to provide a MustUnderstand attribute. If no MustUnderstand attribute is present, false is assumed. The MustUnderstand attribute is conceptually borrowed from SOAP header's "mustUnderstand" attribute.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isMustUnderstand() {
        if (mustUnderstand == null) {
            return false;
        } else {
            return mustUnderstand;
        }
    }

    /**
     * Sets the value of the mustUnderstand property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isMustUnderstand()
     */
    public void setMustUnderstand(Boolean value) {
        this.mustUnderstand = value;
    }

    public void setCodedStringAttribute(List<CodedStringAttributeType> value) {
        this.codedStringAttribute = null;
        if (value!= null) {
            List<CodedStringAttributeType> draftl = this.getCodedStringAttribute();
            draftl.addAll(value);
        }
    }

    public void setCodedIntegerAttribute(List<CodedIntegerAttributeType> value) {
        this.codedIntegerAttribute = null;
        if (value!= null) {
            List<CodedIntegerAttributeType> draftl = this.getCodedIntegerAttribute();
            draftl.addAll(value);
        }
    }

    public void setCodedDecimalAttribute(List<CodedDecimalAttributeType> value) {
        this.codedDecimalAttribute = null;
        if (value!= null) {
            List<CodedDecimalAttributeType> draftl = this.getCodedDecimalAttribute();
            draftl.addAll(value);
        }
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final CodedAttributesType that = ((CodedAttributesType) object);
        {
            List<CodedStringAttributeType> leftCodedStringAttribute;
            leftCodedStringAttribute = (((this.codedStringAttribute!= null)&&(!this.codedStringAttribute.isEmpty()))?this.getCodedStringAttribute():null);
            List<CodedStringAttributeType> rightCodedStringAttribute;
            rightCodedStringAttribute = (((that.codedStringAttribute!= null)&&(!that.codedStringAttribute.isEmpty()))?that.getCodedStringAttribute():null);
            if ((this.codedStringAttribute!= null)&&(!this.codedStringAttribute.isEmpty())) {
                if ((that.codedStringAttribute!= null)&&(!that.codedStringAttribute.isEmpty())) {
                    if (!leftCodedStringAttribute.equals(rightCodedStringAttribute)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.codedStringAttribute!= null)&&(!that.codedStringAttribute.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<CodedIntegerAttributeType> leftCodedIntegerAttribute;
            leftCodedIntegerAttribute = (((this.codedIntegerAttribute!= null)&&(!this.codedIntegerAttribute.isEmpty()))?this.getCodedIntegerAttribute():null);
            List<CodedIntegerAttributeType> rightCodedIntegerAttribute;
            rightCodedIntegerAttribute = (((that.codedIntegerAttribute!= null)&&(!that.codedIntegerAttribute.isEmpty()))?that.getCodedIntegerAttribute():null);
            if ((this.codedIntegerAttribute!= null)&&(!this.codedIntegerAttribute.isEmpty())) {
                if ((that.codedIntegerAttribute!= null)&&(!that.codedIntegerAttribute.isEmpty())) {
                    if (!leftCodedIntegerAttribute.equals(rightCodedIntegerAttribute)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.codedIntegerAttribute!= null)&&(!that.codedIntegerAttribute.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<CodedDecimalAttributeType> leftCodedDecimalAttribute;
            leftCodedDecimalAttribute = (((this.codedDecimalAttribute!= null)&&(!this.codedDecimalAttribute.isEmpty()))?this.getCodedDecimalAttribute():null);
            List<CodedDecimalAttributeType> rightCodedDecimalAttribute;
            rightCodedDecimalAttribute = (((that.codedDecimalAttribute!= null)&&(!that.codedDecimalAttribute.isEmpty()))?that.getCodedDecimalAttribute():null);
            if ((this.codedDecimalAttribute!= null)&&(!this.codedDecimalAttribute.isEmpty())) {
                if ((that.codedDecimalAttribute!= null)&&(!that.codedDecimalAttribute.isEmpty())) {
                    if (!leftCodedDecimalAttribute.equals(rightCodedDecimalAttribute)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.codedDecimalAttribute!= null)&&(!that.codedDecimalAttribute.isEmpty())) {
                    return false;
                }
            }
        }
        {
            boolean leftMustUnderstand;
            leftMustUnderstand = ((this.mustUnderstand!= null)?this.isMustUnderstand():false);
            boolean rightMustUnderstand;
            rightMustUnderstand = ((that.mustUnderstand!= null)?that.isMustUnderstand():false);
            if (this.mustUnderstand!= null) {
                if (that.mustUnderstand!= null) {
                    if (leftMustUnderstand!= rightMustUnderstand) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.mustUnderstand!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            List<CodedStringAttributeType> theCodedStringAttribute;
            theCodedStringAttribute = (((this.codedStringAttribute!= null)&&(!this.codedStringAttribute.isEmpty()))?this.getCodedStringAttribute():null);
            if ((this.codedStringAttribute!= null)&&(!this.codedStringAttribute.isEmpty())) {
                currentHashCode += theCodedStringAttribute.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<CodedIntegerAttributeType> theCodedIntegerAttribute;
            theCodedIntegerAttribute = (((this.codedIntegerAttribute!= null)&&(!this.codedIntegerAttribute.isEmpty()))?this.getCodedIntegerAttribute():null);
            if ((this.codedIntegerAttribute!= null)&&(!this.codedIntegerAttribute.isEmpty())) {
                currentHashCode += theCodedIntegerAttribute.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<CodedDecimalAttributeType> theCodedDecimalAttribute;
            theCodedDecimalAttribute = (((this.codedDecimalAttribute!= null)&&(!this.codedDecimalAttribute.isEmpty()))?this.getCodedDecimalAttribute():null);
            if ((this.codedDecimalAttribute!= null)&&(!this.codedDecimalAttribute.isEmpty())) {
                currentHashCode += theCodedDecimalAttribute.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            boolean theMustUnderstand;
            theMustUnderstand = ((this.mustUnderstand!= null)?this.isMustUnderstand():false);
            if (this.mustUnderstand!= null) {
                currentHashCode += (theMustUnderstand? 1231 : 1237);
            }
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            List<CodedStringAttributeType> theCodedStringAttribute;
            theCodedStringAttribute = (((this.codedStringAttribute!= null)&&(!this.codedStringAttribute.isEmpty()))?this.getCodedStringAttribute():null);
            strategy.appendField(locator, this, "codedStringAttribute", buffer, theCodedStringAttribute, ((this.codedStringAttribute!= null)&&(!this.codedStringAttribute.isEmpty())));
        }
        {
            List<CodedIntegerAttributeType> theCodedIntegerAttribute;
            theCodedIntegerAttribute = (((this.codedIntegerAttribute!= null)&&(!this.codedIntegerAttribute.isEmpty()))?this.getCodedIntegerAttribute():null);
            strategy.appendField(locator, this, "codedIntegerAttribute", buffer, theCodedIntegerAttribute, ((this.codedIntegerAttribute!= null)&&(!this.codedIntegerAttribute.isEmpty())));
        }
        {
            List<CodedDecimalAttributeType> theCodedDecimalAttribute;
            theCodedDecimalAttribute = (((this.codedDecimalAttribute!= null)&&(!this.codedDecimalAttribute.isEmpty()))?this.getCodedDecimalAttribute():null);
            strategy.appendField(locator, this, "codedDecimalAttribute", buffer, theCodedDecimalAttribute, ((this.codedDecimalAttribute!= null)&&(!this.codedDecimalAttribute.isEmpty())));
        }
        {
            boolean theMustUnderstand;
            theMustUnderstand = ((this.mustUnderstand!= null)?this.isMustUnderstand():false);
            strategy.appendField(locator, this, "mustUnderstand", buffer, theMustUnderstand, (this.mustUnderstand!= null));
        }
        return buffer;
    }

    @Override
    public Object clone() {
        return copyTo(createNewInstance());
    }

    @Override
    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.getInstance();
        return copyTo(null, target, strategy);
    }

    @Override
    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof CodedAttributesType) {
            final CodedAttributesType copy = ((CodedAttributesType) draftCopy);
            {
                Boolean codedStringAttributeShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, ((this.codedStringAttribute!= null)&&(!this.codedStringAttribute.isEmpty())));
                if (codedStringAttributeShouldBeCopiedAndSet == Boolean.TRUE) {
                    List<CodedStringAttributeType> sourceCodedStringAttribute;
                    sourceCodedStringAttribute = (((this.codedStringAttribute!= null)&&(!this.codedStringAttribute.isEmpty()))?this.getCodedStringAttribute():null);
                    @SuppressWarnings("unchecked")
                    List<CodedStringAttributeType> copyCodedStringAttribute = ((List<CodedStringAttributeType> ) strategy.copy(LocatorUtils.property(locator, "codedStringAttribute", sourceCodedStringAttribute), sourceCodedStringAttribute, ((this.codedStringAttribute!= null)&&(!this.codedStringAttribute.isEmpty()))));
                    copy.setCodedStringAttribute(copyCodedStringAttribute);
                } else {
                    if (codedStringAttributeShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.codedStringAttribute = null;
                    }
                }
            }
            {
                Boolean codedIntegerAttributeShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, ((this.codedIntegerAttribute!= null)&&(!this.codedIntegerAttribute.isEmpty())));
                if (codedIntegerAttributeShouldBeCopiedAndSet == Boolean.TRUE) {
                    List<CodedIntegerAttributeType> sourceCodedIntegerAttribute;
                    sourceCodedIntegerAttribute = (((this.codedIntegerAttribute!= null)&&(!this.codedIntegerAttribute.isEmpty()))?this.getCodedIntegerAttribute():null);
                    @SuppressWarnings("unchecked")
                    List<CodedIntegerAttributeType> copyCodedIntegerAttribute = ((List<CodedIntegerAttributeType> ) strategy.copy(LocatorUtils.property(locator, "codedIntegerAttribute", sourceCodedIntegerAttribute), sourceCodedIntegerAttribute, ((this.codedIntegerAttribute!= null)&&(!this.codedIntegerAttribute.isEmpty()))));
                    copy.setCodedIntegerAttribute(copyCodedIntegerAttribute);
                } else {
                    if (codedIntegerAttributeShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.codedIntegerAttribute = null;
                    }
                }
            }
            {
                Boolean codedDecimalAttributeShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, ((this.codedDecimalAttribute!= null)&&(!this.codedDecimalAttribute.isEmpty())));
                if (codedDecimalAttributeShouldBeCopiedAndSet == Boolean.TRUE) {
                    List<CodedDecimalAttributeType> sourceCodedDecimalAttribute;
                    sourceCodedDecimalAttribute = (((this.codedDecimalAttribute!= null)&&(!this.codedDecimalAttribute.isEmpty()))?this.getCodedDecimalAttribute():null);
                    @SuppressWarnings("unchecked")
                    List<CodedDecimalAttributeType> copyCodedDecimalAttribute = ((List<CodedDecimalAttributeType> ) strategy.copy(LocatorUtils.property(locator, "codedDecimalAttribute", sourceCodedDecimalAttribute), sourceCodedDecimalAttribute, ((this.codedDecimalAttribute!= null)&&(!this.codedDecimalAttribute.isEmpty()))));
                    copy.setCodedDecimalAttribute(copyCodedDecimalAttribute);
                } else {
                    if (codedDecimalAttributeShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.codedDecimalAttribute = null;
                    }
                }
            }
            {
                Boolean mustUnderstandShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.mustUnderstand!= null));
                if (mustUnderstandShouldBeCopiedAndSet == Boolean.TRUE) {
                    boolean sourceMustUnderstand;
                    sourceMustUnderstand = ((this.mustUnderstand!= null)?this.isMustUnderstand():false);
                    boolean copyMustUnderstand = strategy.copy(LocatorUtils.property(locator, "mustUnderstand", sourceMustUnderstand), sourceMustUnderstand, (this.mustUnderstand!= null));
                    copy.setMustUnderstand(copyMustUnderstand);
                } else {
                    if (mustUnderstandShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.mustUnderstand = null;
                    }
                }
            }
        }
        return draftCopy;
    }

    @Override
    public Object createNewInstance() {
        return new CodedAttributesType();
    }

}
