
package org.somda.sdpi.model;

import java.math.BigInteger;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.CopyStrategy;
import org.jvnet.jaxb.lang.CopyTo;
import org.jvnet.jaxb.lang.JAXBCopyStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Type definition of CodedIntegerAttribute.
 * 
 * <p>Java class for CodedIntegerAttributeType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="CodedIntegerAttributeType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oid:1.3.6.1.4.1.19376.1.6.2.10.1.1.1}MdcAttribute"/>
 *         <element name="Value" type="{http://www.w3.org/2001/XMLSchema}integer"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CodedIntegerAttributeType", namespace = "urn:oid:1.3.6.1.4.1.19376.1.6.2.10.1.1.1", propOrder = {
    "mdcAttribute",
    "value"
})
public class CodedIntegerAttributeType implements Cloneable, CopyTo, ToString
{

    /**
     * Key of the key value pair. Describes the meaning of Value.
     * 
     */
    @XmlElement(name = "MdcAttribute", namespace = "urn:oid:1.3.6.1.4.1.19376.1.6.2.10.1.1.1", required = true)
    protected MdcAttributeType mdcAttribute;
    /**
     * Value (user data) of the key value pair.
     * 
     */
    @XmlElement(name = "Value", namespace = "urn:oid:1.3.6.1.4.1.19376.1.6.2.10.1.1.1", required = true)
    protected BigInteger value;

    /**
     * Key of the key value pair. Describes the meaning of Value.
     * 
     * @return
     *     possible object is
     *     {@link MdcAttributeType }
     *     
     */
    public MdcAttributeType getMdcAttribute() {
        return mdcAttribute;
    }

    /**
     * Sets the value of the mdcAttribute property.
     * 
     * @param value
     *     allowed object is
     *     {@link MdcAttributeType }
     *     
     * @see #getMdcAttribute()
     */
    public void setMdcAttribute(MdcAttributeType value) {
        this.mdcAttribute = value;
    }

    /**
     * Value (user data) of the key value pair.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     * @see #getValue()
     */
    public void setValue(BigInteger value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final CodedIntegerAttributeType that = ((CodedIntegerAttributeType) object);
        {
            MdcAttributeType leftMdcAttribute;
            leftMdcAttribute = this.getMdcAttribute();
            MdcAttributeType rightMdcAttribute;
            rightMdcAttribute = that.getMdcAttribute();
            if (this.mdcAttribute!= null) {
                if (that.mdcAttribute!= null) {
                    if (!leftMdcAttribute.equals(rightMdcAttribute)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.mdcAttribute!= null) {
                    return false;
                }
            }
        }
        {
            BigInteger leftValue;
            leftValue = this.getValue();
            BigInteger rightValue;
            rightValue = that.getValue();
            if (this.value!= null) {
                if (that.value!= null) {
                    if (!leftValue.equals(rightValue)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.value!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            MdcAttributeType theMdcAttribute;
            theMdcAttribute = this.getMdcAttribute();
            if (this.mdcAttribute!= null) {
                currentHashCode += theMdcAttribute.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            BigInteger theValue;
            theValue = this.getValue();
            if (this.value!= null) {
                currentHashCode += theValue.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            MdcAttributeType theMdcAttribute;
            theMdcAttribute = this.getMdcAttribute();
            strategy.appendField(locator, this, "mdcAttribute", buffer, theMdcAttribute, (this.mdcAttribute!= null));
        }
        {
            BigInteger theValue;
            theValue = this.getValue();
            strategy.appendField(locator, this, "value", buffer, theValue, (this.value!= null));
        }
        return buffer;
    }

    @Override
    public Object clone() {
        return copyTo(createNewInstance());
    }

    @Override
    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.getInstance();
        return copyTo(null, target, strategy);
    }

    @Override
    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof CodedIntegerAttributeType) {
            final CodedIntegerAttributeType copy = ((CodedIntegerAttributeType) draftCopy);
            {
                Boolean mdcAttributeShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.mdcAttribute!= null));
                if (mdcAttributeShouldBeCopiedAndSet == Boolean.TRUE) {
                    MdcAttributeType sourceMdcAttribute;
                    sourceMdcAttribute = this.getMdcAttribute();
                    MdcAttributeType copyMdcAttribute = ((MdcAttributeType) strategy.copy(LocatorUtils.property(locator, "mdcAttribute", sourceMdcAttribute), sourceMdcAttribute, (this.mdcAttribute!= null)));
                    copy.setMdcAttribute(copyMdcAttribute);
                } else {
                    if (mdcAttributeShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.mdcAttribute = null;
                    }
                }
            }
            {
                Boolean valueShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.value!= null));
                if (valueShouldBeCopiedAndSet == Boolean.TRUE) {
                    BigInteger sourceValue;
                    sourceValue = this.getValue();
                    BigInteger copyValue = ((BigInteger) strategy.copy(LocatorUtils.property(locator, "value", sourceValue), sourceValue, (this.value!= null)));
                    copy.setValue(copyValue);
                } else {
                    if (valueShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.value = null;
                    }
                }
            }
        }
        return draftCopy;
    }

    @Override
    public Object createNewInstance() {
        return new CodedIntegerAttributeType();
    }

}
