
package org.somda.sdpi.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import org.jvnet.jaxb.lang.CopyStrategy;
import org.jvnet.jaxb.lang.CopyTo;
import org.jvnet.jaxb.lang.JAXBCopyStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * <p>Java class for anonymous complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType>
 *   <simpleContent>
 *     <extension base="<urn:oid:1.3.6.1.4.1.19376.1.6.2.10.1.1.1>EquipmentIdentifierType">
 *       <attribute ref="{http://standards.ieee.org/downloads/11073/11073-10207-2017/extension}MustUnderstand"/>
 *     </extension>
 *   </simpleContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "value"
})
@XmlRootElement(name = "EquipmentIdentifier", namespace = "urn:oid:1.3.6.1.4.1.19376.1.6.2.10.1.1.1")
public class EquipmentIdentifier implements Cloneable, CopyTo, ToString
{

    /**
     * Type defining the EquipmentIdentifier.
     * 
     * The equipment identifier is an URI. It is stable, globally unique and constant across re-initializations of the SOMDS Provider.
     * 
     */
    @XmlValue
    protected String value;
    /**
     * In cases where an extension modifies the meaning of the element that contains it, a MustUnderstand attribute is senseful. This means that the data cannot safely be processed unless the application knows the meaning of the extension. A MustUnderstand marked extension could be look like this:
     * 
     * tns:Extension xmlns:tns="http://standards.ieee.org/downloads/11073/11073-10207-2017/extension" xmlns:ext="http://concrete-extension-namespace"
     *   ext:AdditionalInfo tns:MustUnderstand="true"
     *     ...
     * 
     * 
     * Extensions are not required to provide a MustUnderstand attribute. If no MustUnderstand attribute is present, false is assumed. The MustUnderstand attribute is conceptually borrowed from SOAP header's "mustUnderstand" attribute.
     * 
     */
    @XmlAttribute(name = "MustUnderstand", namespace = "http://standards.ieee.org/downloads/11073/11073-10207-2017/extension")
    protected Boolean mustUnderstand;

    /**
     * Type defining the EquipmentIdentifier.
     * 
     * The equipment identifier is an URI. It is stable, globally unique and constant across re-initializations of the SOMDS Provider.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getValue()
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * In cases where an extension modifies the meaning of the element that contains it, a MustUnderstand attribute is senseful. This means that the data cannot safely be processed unless the application knows the meaning of the extension. A MustUnderstand marked extension could be look like this:
     * 
     * tns:Extension xmlns:tns="http://standards.ieee.org/downloads/11073/11073-10207-2017/extension" xmlns:ext="http://concrete-extension-namespace"
     *   ext:AdditionalInfo tns:MustUnderstand="true"
     *     ...
     * 
     * 
     * Extensions are not required to provide a MustUnderstand attribute. If no MustUnderstand attribute is present, false is assumed. The MustUnderstand attribute is conceptually borrowed from SOAP header's "mustUnderstand" attribute.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isMustUnderstand() {
        if (mustUnderstand == null) {
            return false;
        } else {
            return mustUnderstand;
        }
    }

    /**
     * Sets the value of the mustUnderstand property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isMustUnderstand()
     */
    public void setMustUnderstand(Boolean value) {
        this.mustUnderstand = value;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final EquipmentIdentifier that = ((EquipmentIdentifier) object);
        {
            String leftValue;
            leftValue = this.getValue();
            String rightValue;
            rightValue = that.getValue();
            if (this.value!= null) {
                if (that.value!= null) {
                    if (!leftValue.equals(rightValue)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.value!= null) {
                    return false;
                }
            }
        }
        {
            boolean leftMustUnderstand;
            leftMustUnderstand = ((this.mustUnderstand!= null)?this.isMustUnderstand():false);
            boolean rightMustUnderstand;
            rightMustUnderstand = ((that.mustUnderstand!= null)?that.isMustUnderstand():false);
            if (this.mustUnderstand!= null) {
                if (that.mustUnderstand!= null) {
                    if (leftMustUnderstand!= rightMustUnderstand) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.mustUnderstand!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theValue;
            theValue = this.getValue();
            if (this.value!= null) {
                currentHashCode += theValue.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            boolean theMustUnderstand;
            theMustUnderstand = ((this.mustUnderstand!= null)?this.isMustUnderstand():false);
            if (this.mustUnderstand!= null) {
                currentHashCode += (theMustUnderstand? 1231 : 1237);
            }
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theValue;
            theValue = this.getValue();
            strategy.appendField(locator, this, "value", buffer, theValue, (this.value!= null));
        }
        {
            boolean theMustUnderstand;
            theMustUnderstand = ((this.mustUnderstand!= null)?this.isMustUnderstand():false);
            strategy.appendField(locator, this, "mustUnderstand", buffer, theMustUnderstand, (this.mustUnderstand!= null));
        }
        return buffer;
    }

    @Override
    public Object clone() {
        return copyTo(createNewInstance());
    }

    @Override
    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.getInstance();
        return copyTo(null, target, strategy);
    }

    @Override
    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof EquipmentIdentifier) {
            final EquipmentIdentifier copy = ((EquipmentIdentifier) draftCopy);
            {
                Boolean valueShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.value!= null));
                if (valueShouldBeCopiedAndSet == Boolean.TRUE) {
                    String sourceValue;
                    sourceValue = this.getValue();
                    String copyValue = ((String) strategy.copy(LocatorUtils.property(locator, "value", sourceValue), sourceValue, (this.value!= null)));
                    copy.setValue(copyValue);
                } else {
                    if (valueShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.value = null;
                    }
                }
            }
            {
                Boolean mustUnderstandShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.mustUnderstand!= null));
                if (mustUnderstandShouldBeCopiedAndSet == Boolean.TRUE) {
                    boolean sourceMustUnderstand;
                    sourceMustUnderstand = ((this.mustUnderstand!= null)?this.isMustUnderstand():false);
                    boolean copyMustUnderstand = strategy.copy(LocatorUtils.property(locator, "mustUnderstand", sourceMustUnderstand), sourceMustUnderstand, (this.mustUnderstand!= null));
                    copy.setMustUnderstand(copyMustUnderstand);
                } else {
                    if (mustUnderstandShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.mustUnderstand = null;
                    }
                }
            }
        }
        return draftCopy;
    }

    @Override
    public Object createNewInstance() {
        return new EquipmentIdentifier();
    }

}
