
package org.somda.sdpi.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.CopyStrategy;
import org.jvnet.jaxb.lang.CopyTo;
import org.jvnet.jaxb.lang.JAXBCopyStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Type definition of MdcAttribute.
 * 
 * <p>Java class for MdcAttributeType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="MdcAttributeType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="Code" use="required" type="{http://standards.ieee.org/downloads/11073/11073-10207-2017/participant}CodeIdentifier" />
 *       <attribute name="CodingSystem" type="{http://www.w3.org/2001/XMLSchema}anyURI" />
 *       <attribute name="CodingSystemVersion" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="SymbolicCodeName" type="{http://standards.ieee.org/downloads/11073/11073-10207-2017/participant}SymbolicCodeName" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "MdcAttributeType", namespace = "urn:oid:1.3.6.1.4.1.19376.1.6.2.10.1.1.1")
public class MdcAttributeType implements Cloneable, CopyTo, ToString
{

    @XmlAttribute(name = "Code", required = true)
    protected String code;
    /**
     * The coding system of the this coded attribute. The implied value is "urn:oid:1.3.111.2.11073.10101.1".
     * 
     */
    @XmlAttribute(name = "CodingSystem")
    @XmlSchemaType(name = "anyURI")
    protected String codingSystem;
    /**
     * CodingSystemVersion can be used to discriminate between different versions of a coding system. CodingSystemVersion is an optional value and can be omitted in cases where a coding system is backwards compatible or CodingSystem includes versioning information.
     * 
     */
    @XmlAttribute(name = "CodingSystemVersion")
    protected String codingSystemVersion;
    /**
     * If present, SymbolicCodeName is an alternative representation that can be used to perform a plausibility check against Code.
     * 
     */
    @XmlAttribute(name = "SymbolicCodeName")
    protected String symbolicCodeName;

    /**
     * Gets the value of the code property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCode() {
        return code;
    }

    /**
     * Sets the value of the code property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCode(String value) {
        this.code = value;
    }

    /**
     * The coding system of the this coded attribute. The implied value is "urn:oid:1.3.111.2.11073.10101.1".
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCodingSystem() {
        return codingSystem;
    }

    /**
     * Sets the value of the codingSystem property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCodingSystem()
     */
    public void setCodingSystem(String value) {
        this.codingSystem = value;
    }

    /**
     * CodingSystemVersion can be used to discriminate between different versions of a coding system. CodingSystemVersion is an optional value and can be omitted in cases where a coding system is backwards compatible or CodingSystem includes versioning information.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCodingSystemVersion() {
        return codingSystemVersion;
    }

    /**
     * Sets the value of the codingSystemVersion property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCodingSystemVersion()
     */
    public void setCodingSystemVersion(String value) {
        this.codingSystemVersion = value;
    }

    /**
     * If present, SymbolicCodeName is an alternative representation that can be used to perform a plausibility check against Code.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSymbolicCodeName() {
        return symbolicCodeName;
    }

    /**
     * Sets the value of the symbolicCodeName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getSymbolicCodeName()
     */
    public void setSymbolicCodeName(String value) {
        this.symbolicCodeName = value;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final MdcAttributeType that = ((MdcAttributeType) object);
        {
            String leftCode;
            leftCode = this.getCode();
            String rightCode;
            rightCode = that.getCode();
            if (this.code!= null) {
                if (that.code!= null) {
                    if (!leftCode.equals(rightCode)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.code!= null) {
                    return false;
                }
            }
        }
        {
            String leftCodingSystem;
            leftCodingSystem = this.getCodingSystem();
            String rightCodingSystem;
            rightCodingSystem = that.getCodingSystem();
            if (this.codingSystem!= null) {
                if (that.codingSystem!= null) {
                    if (!leftCodingSystem.equals(rightCodingSystem)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.codingSystem!= null) {
                    return false;
                }
            }
        }
        {
            String leftCodingSystemVersion;
            leftCodingSystemVersion = this.getCodingSystemVersion();
            String rightCodingSystemVersion;
            rightCodingSystemVersion = that.getCodingSystemVersion();
            if (this.codingSystemVersion!= null) {
                if (that.codingSystemVersion!= null) {
                    if (!leftCodingSystemVersion.equals(rightCodingSystemVersion)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.codingSystemVersion!= null) {
                    return false;
                }
            }
        }
        {
            String leftSymbolicCodeName;
            leftSymbolicCodeName = this.getSymbolicCodeName();
            String rightSymbolicCodeName;
            rightSymbolicCodeName = that.getSymbolicCodeName();
            if (this.symbolicCodeName!= null) {
                if (that.symbolicCodeName!= null) {
                    if (!leftSymbolicCodeName.equals(rightSymbolicCodeName)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.symbolicCodeName!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theCode;
            theCode = this.getCode();
            if (this.code!= null) {
                currentHashCode += theCode.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theCodingSystem;
            theCodingSystem = this.getCodingSystem();
            if (this.codingSystem!= null) {
                currentHashCode += theCodingSystem.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theCodingSystemVersion;
            theCodingSystemVersion = this.getCodingSystemVersion();
            if (this.codingSystemVersion!= null) {
                currentHashCode += theCodingSystemVersion.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theSymbolicCodeName;
            theSymbolicCodeName = this.getSymbolicCodeName();
            if (this.symbolicCodeName!= null) {
                currentHashCode += theSymbolicCodeName.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theCode;
            theCode = this.getCode();
            strategy.appendField(locator, this, "code", buffer, theCode, (this.code!= null));
        }
        {
            String theCodingSystem;
            theCodingSystem = this.getCodingSystem();
            strategy.appendField(locator, this, "codingSystem", buffer, theCodingSystem, (this.codingSystem!= null));
        }
        {
            String theCodingSystemVersion;
            theCodingSystemVersion = this.getCodingSystemVersion();
            strategy.appendField(locator, this, "codingSystemVersion", buffer, theCodingSystemVersion, (this.codingSystemVersion!= null));
        }
        {
            String theSymbolicCodeName;
            theSymbolicCodeName = this.getSymbolicCodeName();
            strategy.appendField(locator, this, "symbolicCodeName", buffer, theSymbolicCodeName, (this.symbolicCodeName!= null));
        }
        return buffer;
    }

    @Override
    public Object clone() {
        return copyTo(createNewInstance());
    }

    @Override
    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.getInstance();
        return copyTo(null, target, strategy);
    }

    @Override
    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof MdcAttributeType) {
            final MdcAttributeType copy = ((MdcAttributeType) draftCopy);
            {
                Boolean codeShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.code!= null));
                if (codeShouldBeCopiedAndSet == Boolean.TRUE) {
                    String sourceCode;
                    sourceCode = this.getCode();
                    String copyCode = ((String) strategy.copy(LocatorUtils.property(locator, "code", sourceCode), sourceCode, (this.code!= null)));
                    copy.setCode(copyCode);
                } else {
                    if (codeShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.code = null;
                    }
                }
            }
            {
                Boolean codingSystemShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.codingSystem!= null));
                if (codingSystemShouldBeCopiedAndSet == Boolean.TRUE) {
                    String sourceCodingSystem;
                    sourceCodingSystem = this.getCodingSystem();
                    String copyCodingSystem = ((String) strategy.copy(LocatorUtils.property(locator, "codingSystem", sourceCodingSystem), sourceCodingSystem, (this.codingSystem!= null)));
                    copy.setCodingSystem(copyCodingSystem);
                } else {
                    if (codingSystemShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.codingSystem = null;
                    }
                }
            }
            {
                Boolean codingSystemVersionShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.codingSystemVersion!= null));
                if (codingSystemVersionShouldBeCopiedAndSet == Boolean.TRUE) {
                    String sourceCodingSystemVersion;
                    sourceCodingSystemVersion = this.getCodingSystemVersion();
                    String copyCodingSystemVersion = ((String) strategy.copy(LocatorUtils.property(locator, "codingSystemVersion", sourceCodingSystemVersion), sourceCodingSystemVersion, (this.codingSystemVersion!= null)));
                    copy.setCodingSystemVersion(copyCodingSystemVersion);
                } else {
                    if (codingSystemVersionShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.codingSystemVersion = null;
                    }
                }
            }
            {
                Boolean symbolicCodeNameShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.symbolicCodeName!= null));
                if (symbolicCodeNameShouldBeCopiedAndSet == Boolean.TRUE) {
                    String sourceSymbolicCodeName;
                    sourceSymbolicCodeName = this.getSymbolicCodeName();
                    String copySymbolicCodeName = ((String) strategy.copy(LocatorUtils.property(locator, "symbolicCodeName", sourceSymbolicCodeName), sourceSymbolicCodeName, (this.symbolicCodeName!= null)));
                    copy.setSymbolicCodeName(copySymbolicCodeName);
                } else {
                    if (symbolicCodeNameShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.symbolicCodeName = null;
                    }
                }
            }
        }
        return draftCopy;
    }

    @Override
    public Object createNewInstance() {
        return new MdcAttributeType();
    }

}
