/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.ConditionalStructure;

public abstract class ConditionalStructureCheckBase
extends FlexCheck {
    private Set<AstNode> visitedIfStatements = new HashSet<AstNode>();

    public void visitFile(@Nullable AstNode node) {
        this.visitedIfStatements.clear();
    }

    public List<AstNodeType> subscribedTo() {
        return Arrays.asList(FlexGrammar.IF_STATEMENT, FlexGrammar.SWITCH_STATEMENT);
    }

    public void visitNode(AstNode node) {
        ConditionalStructure conditionalStructure;
        if (node.is(new AstNodeType[]{FlexGrammar.IF_STATEMENT})) {
            if (!this.visitedIfStatements.add(node)) {
                return;
            }
            conditionalStructure = ConditionalStructure.ifStatement(node, this.visitedIfStatements);
        } else {
            conditionalStructure = ConditionalStructure.switchStatement(node);
        }
        this.visitConditionalStructure(conditionalStructure);
    }

    abstract void visitConditionalStructure(ConditionalStructure var1);
}

