/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;

@Rule(key="S4524")
public class DefaultCasePositionCheck
extends FlexCheck {
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.SWITCH_STATEMENT);
    }

    public void visitNode(AstNode astNode) {
        AstNode previous = null;
        int nbCase = 0;
        for (AstNode caseElement : astNode.getChildren(new AstNodeType[]{FlexGrammar.CASE_ELEMENT})) {
            for (AstNode caseLabel : caseElement.getChildren(new AstNodeType[]{FlexGrammar.CASE_LABEL})) {
                if (previous != null && nbCase > 1 && previous.getFirstChild().is(new AstNodeType[]{FlexKeyword.DEFAULT})) {
                    this.addIssue("Move this \"default\" clause to the beginning or end of this \"switch\" statement.", previous);
                    return;
                }
                previous = caseLabel;
                ++nbCase;
            }
        }
    }
}

