/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Clazz;

@Rule(key="S1445")
public class ConstructorWithVoidReturnTypeCheck
extends FlexCheck {
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.CLASS_DEF);
    }

    public void visitNode(AstNode astNode) {
        AstNode constructorDef = Clazz.getConstructor(astNode);
        if (constructorDef != null && ConstructorWithVoidReturnTypeCheck.hasVoidReturnType(constructorDef)) {
            String className = astNode.getFirstChild(new AstNodeType[]{FlexGrammar.CLASS_NAME}).getFirstChild(new AstNodeType[]{FlexGrammar.CLASS_IDENTIFIERS}).getLastChild().getTokenValue();
            this.addIssue(MessageFormat.format("Remove the \"void\" return type from this \"{0}\" constructor", className), constructorDef);
        }
    }

    private static boolean hasVoidReturnType(AstNode functionDef) {
        AstNode resultTypeNode = functionDef.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_COMMON}).getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_SIGNATURE}).getFirstChild(new AstNodeType[]{FlexGrammar.RESULT_TYPE});
        return resultTypeNode != null && resultTypeNode.getFirstChild(new AstNodeType[]{FlexKeyword.VOID}) != null;
    }
}

