/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexPunctuator;

@Rule(key="S108")
public class EmptyNestedBlockCheck
extends FlexCheck {
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.BLOCK);
    }

    public void visitNode(AstNode astNode) {
        if (!astNode.getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVES}).hasChildren() && EmptyNestedBlockCheck.isNested(astNode) && !EmptyNestedBlockCheck.hasComment(astNode)) {
            this.addIssue("Either remove or fill this block of code.", astNode);
        }
    }

    private static boolean isNested(AstNode blockNode) {
        return !blockNode.getParent().is(new AstNodeType[]{FlexGrammar.CLASS_DEF, FlexGrammar.INTERFACE_DEF, FlexGrammar.PACKAGE_DEF, FlexGrammar.FUNCTION_COMMON});
    }

    private static boolean hasComment(AstNode blockNode) {
        return blockNode.getFirstChild(new AstNodeType[]{FlexPunctuator.RCURLYBRACE}).getToken().hasTrivia();
    }
}

