/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.flex.checks.utils.Function;

@Rule(key="S100")
public class FunctionNameCheck
extends FlexCheck {
    private static final String DEFAULT = "^[a-z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    private Deque<String> classes = new ArrayDeque<String>();
    @RuleProperty(key="format", description="Regular expression used to check the function names against", defaultValue="^[a-z][a-zA-Z0-9]*$")
    String format = "^[a-z][a-zA-Z0-9]*$";

    public List<AstNodeType> subscribedTo() {
        return Arrays.asList(FlexGrammar.FUNCTION_DEF, FlexGrammar.CLASS_DEF);
    }

    public void visitFile(@Nullable AstNode astNode) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format);
        }
        this.classes.clear();
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{FlexGrammar.CLASS_DEF})) {
            this.classes.push(Clazz.getName(astNode));
        } else {
            String functionName = Function.getName(astNode);
            if (!this.isConstructor(astNode) && !this.pattern.matcher(functionName).matches()) {
                this.addIssue(MessageFormat.format("Rename this \"{0}\" function to match the regular expression {1}", functionName, this.format), astNode);
            }
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{FlexGrammar.CLASS_DEF})) {
            this.classes.pop();
        }
    }

    private boolean isConstructor(AstNode functionNode) {
        return !this.classes.isEmpty() && Function.isConstructor(functionNode, this.classes.peek());
    }
}

