/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.MetadataTag;

@Rule(key="S1464")
public class ManagedEventTagWithEventCheck
extends FlexCheck {
    private Map<String, Boolean> isDeclaredInEventTag = new HashMap<String, Boolean>();

    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.METADATA_STATEMENT);
    }

    public void visitNode(AstNode astNode) {
        if (!MetadataTag.isTag(astNode, "ManagedEvents")) {
            return;
        }
        this.initEventMap(MetadataTag.getSinglePropertyAsList(astNode));
        this.searchEventInPreviousTag(astNode);
        this.searchEventInNextTag(astNode);
        for (Map.Entry<String, Boolean> entry : this.isDeclaredInEventTag.entrySet()) {
            if (!Boolean.FALSE.equals(entry.getValue())) continue;
            this.addIssue(MessageFormat.format("The managed event {0} is either misspelled or is missing a companion Event metadata tag", entry.getKey()), astNode);
        }
        this.isDeclaredInEventTag.clear();
    }

    private void initEventMap(List<String> managedEventNames) {
        for (String eventName : managedEventNames) {
            this.isDeclaredInEventTag.put("\"" + eventName + "\"", false);
        }
    }

    private void searchEventInPreviousTag(AstNode metadata) {
        for (AstNode previousDirective = metadata.getParent().getParent().getPreviousAstNode(); previousDirective != null && MetadataTag.isMetadataTag(previousDirective); previousDirective = previousDirective.getPreviousAstNode()) {
            this.checkEventTag(previousDirective);
        }
    }

    private void searchEventInNextTag(AstNode metadata) {
        for (AstNode nextDirective = metadata.getParent().getParent().getNextAstNode(); nextDirective != null && MetadataTag.isMetadataTag(nextDirective); nextDirective = nextDirective.getNextAstNode()) {
            this.checkEventTag(nextDirective);
        }
    }

    private void checkEventTag(AstNode directive) {
        AstNode metadataStmt = directive.getFirstChild().getFirstChild(new AstNodeType[]{FlexGrammar.METADATA_STATEMENT});
        if (MetadataTag.isTag(metadataStmt, "Event")) {
            String eventName = MetadataTag.getTagPropertiesMap(metadataStmt).get("name");
            this.isDeclaredInEventTag.computeIfPresent(eventName, (key, value) -> true);
        }
    }
}

