/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks.utils;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.ArrayList;
import java.util.List;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Preconditions;

public final class Variable {
    private Variable() {
    }

    public static String getName(AstNode varDeclStatement) {
        Preconditions.checkState(varDeclStatement.is(new AstNodeType[]{FlexGrammar.VARIABLE_DECLARATION_STATEMENT}));
        return varDeclStatement.getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_DEF}).getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_BINDING_LIST}).getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_BINDING}).getFirstChild(new AstNodeType[]{FlexGrammar.TYPED_IDENTIFIER}).getFirstChild(new AstNodeType[]{FlexGrammar.IDENTIFIER}).getTokenValue();
    }

    public static boolean isVariable(AstNode directive) {
        AstNode variableDecStmt;
        Preconditions.checkState(directive.is(new AstNodeType[]{FlexGrammar.DIRECTIVE}));
        if (directive.getFirstChild(new AstNodeType[]{FlexGrammar.ANNOTABLE_DIRECTIVE}) != null && (variableDecStmt = directive.getFirstChild(new AstNodeType[]{FlexGrammar.ANNOTABLE_DIRECTIVE}).getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_DECLARATION_STATEMENT})) != null) {
            return variableDecStmt.getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_DEF}).getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_DEF_KIND}).getFirstChild().is(new AstNodeType[]{FlexKeyword.VAR});
        }
        return false;
    }

    public static boolean isConst(AstNode directive) {
        AstNode variableDecStmt;
        Preconditions.checkState(directive.is(new AstNodeType[]{FlexGrammar.DIRECTIVE}));
        if (directive.getFirstChild(new AstNodeType[]{FlexGrammar.ANNOTABLE_DIRECTIVE}) != null && (variableDecStmt = directive.getFirstChild(new AstNodeType[]{FlexGrammar.ANNOTABLE_DIRECTIVE}).getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_DECLARATION_STATEMENT})) != null) {
            return variableDecStmt.getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_DEF}).getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_DEF_KIND}).getFirstChild().is(new AstNodeType[]{FlexKeyword.CONST});
        }
        return false;
    }

    public static List<AstNode> getDeclaredIdentifiers(AstNode varDeclStatement) {
        Preconditions.checkState(varDeclStatement.is(new AstNodeType[]{FlexGrammar.VARIABLE_DECLARATION_STATEMENT}));
        ArrayList<AstNode> identifiers = new ArrayList<AstNode>();
        if (varDeclStatement.is(new AstNodeType[]{FlexGrammar.VARIABLE_DECLARATION_STATEMENT})) {
            AstNode varBindingList = varDeclStatement.getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_DEF}).getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_BINDING_LIST});
            for (AstNode varBinding : varBindingList.getChildren(new AstNodeType[]{FlexGrammar.VARIABLE_BINDING})) {
                identifiers.add(varBinding.getFirstChild(new AstNodeType[]{FlexGrammar.TYPED_IDENTIFIER}).getFirstChild(new AstNodeType[]{FlexGrammar.IDENTIFIER}));
            }
        }
        return identifiers;
    }
}

