/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Expression;

@Rule(key="S1950")
public class DuplicateSwitchCaseConditionCheck
extends FlexCheck {
    private Map<String, AstNode> casesByCondition = new HashMap<String, AstNode>();

    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.SWITCH_STATEMENT);
    }

    public void visitNode(AstNode astNode) {
        for (AstNode caseElement : astNode.getChildren(new AstNodeType[]{FlexGrammar.CASE_ELEMENT})) {
            for (AstNode caseLabel : caseElement.getChildren(new AstNodeType[]{FlexGrammar.CASE_LABEL})) {
                if (caseLabel.getFirstChild().is(new AstNodeType[]{FlexKeyword.DEFAULT})) continue;
                this.checkCondition(caseLabel);
            }
        }
        this.casesByCondition.clear();
    }

    private void checkCondition(AstNode caseLabel) {
        String expression = Expression.exprToString(caseLabel.getFirstChild(new AstNodeType[]{FlexGrammar.LIST_EXPRESSION}));
        AstNode duplicateCase = this.casesByCondition.get(expression);
        if (duplicateCase != null) {
            this.addIssue(MessageFormat.format("This case duplicates the case on line {0} with condition \"{1}\".", duplicateCase.getTokenLine(), expression), caseLabel);
        } else {
            this.casesByCondition.put(expression, caseLabel);
        }
    }
}

