/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="ActionScript2", name="Statements, operators and keywords specific to ActionScript 2 should not be used", priority=Priority.BLOCKER, tags={"obsolete"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LANGUAGE_RELATED_PORTABILITY")
@SqaleConstantRemediation(value="2min")
public class ActionScript2Check
extends SquidCheck<LexerlessGrammar> {
    private final Set<String> deprecatedOperators = ImmutableSet.of((Object)"or", (Object)"and", (Object)"ne", (Object)"eq", (Object)"ge", (Object)"gt", (Object[])new String[]{"le", "lt", "add", "<>"});

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.UNARY_EXPR, FlexGrammar.LOGICAL_OR_OPERATOR, FlexGrammar.LOGICAL_AND_OPERATOR, FlexGrammar.EQUALITY_OPERATOR, FlexGrammar.RELATIONAL_OPERATOR, FlexGrammar.RELATIONAL_OPERATOR_NO_IN, FlexGrammar.ADDITIVE_OPERATOR});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{FlexGrammar.UNARY_EXPR}) && "not".equals(astNode.getFirstChild().getTokenValue())) {
            this.getContext().createLineViolation((CodeCheck)this, "Operator 'not' not available in ActionScript 3.0", astNode.getFirstChild(), new Object[0]);
        } else {
            String operator = ActionScript2Check.getValue(astNode);
            if (this.deprecatedOperators.contains(operator)) {
                this.getContext().createLineViolation((CodeCheck)this, "Operator '" + operator + "' not available in ActionScript 3.0", astNode, new Object[0]);
            }
        }
    }

    private static String getValue(AstNode astNode) {
        StringBuilder sb = new StringBuilder();
        for (AstNode child : astNode.getChildren()) {
            sb.append(child.getTokenValue());
        }
        return sb.toString();
    }
}

