/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1442", name="\"Alert.show(...)\" should not be used", priority=Priority.MAJOR, tags={"cwe", "security", "user-experience"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="10min")
public class AlertShowUseCheck
extends SquidCheck<LexerlessGrammar>
implements AstAndTokenVisitor {
    private static final State[][] TRANSITIONS = new State[State.values().length][Symbol.values().length];
    private State currentState;

    public void visitFile(@Nullable AstNode node) {
        this.currentState = State.EXPECTING_ALERT;
    }

    public void visitToken(Token token) {
        this.currentState = TRANSITIONS[this.currentState.ordinal()][AlertShowUseCheck.getSymbol(token.getOriginalValue()).ordinal()];
        if (this.currentState == State.FOUND_ISSUE) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove this usage of Alert.show().", token, new Object[0]);
            this.currentState = State.EXPECTING_ALERT;
        }
    }

    private static Symbol getSymbol(String value) {
        Symbol result = Symbol.OTHER;
        if (".".equals(value)) {
            result = Symbol.DOT;
        } else if ("Alert".equals(value)) {
            result = Symbol.ALERT;
        } else if ("show".equals(value)) {
            result = Symbol.SHOW;
        }
        return result;
    }

    static {
        for (int i = 0; i < TRANSITIONS.length; ++i) {
            for (int j = 0; j < TRANSITIONS[i].length; ++j) {
                AlertShowUseCheck.TRANSITIONS[i][j] = State.EXPECTING_ALERT;
            }
        }
        AlertShowUseCheck.TRANSITIONS[State.EXPECTING_ALERT.ordinal()][Symbol.ALERT.ordinal()] = State.EXPECTING_DOT;
        AlertShowUseCheck.TRANSITIONS[State.EXPECTING_DOT.ordinal()][Symbol.DOT.ordinal()] = State.EXPECTING_SHOW;
        AlertShowUseCheck.TRANSITIONS[State.EXPECTING_SHOW.ordinal()][Symbol.SHOW.ordinal()] = State.FOUND_ISSUE;
    }

    private static enum Symbol {
        OTHER,
        ALERT,
        DOT,
        SHOW;

    }

    private static enum State {
        EXPECTING_ALERT,
        EXPECTING_DOT,
        EXPECTING_SHOW,
        FOUND_ISSUE;

    }
}

