/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.flex.checks.utils.MetadataTag;
import org.sonar.flex.checks.utils.Variable;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1469", name="The element type of an array field should be specified", priority=Priority.MAJOR, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ArrayFieldElementTypeCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.CLASS_DEF});
    }

    public void visitNode(AstNode astNode) {
        for (AstNode directive : Clazz.getDirectives(astNode)) {
            if (!Variable.isVariable(directive)) continue;
            AstNode varBindingList = directive.getFirstChild(new AstNodeType[]{FlexGrammar.ANNOTABLE_DIRECTIVE}).getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_DECLARATION_STATEMENT}).getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_DEF}).getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_BINDING_LIST});
            for (AstNode varBinding : varBindingList.getChildren(new AstNodeType[]{FlexGrammar.VARIABLE_BINDING})) {
                if (ArrayFieldElementTypeCheck.hasInitialisation(varBinding) || !ArrayFieldElementTypeCheck.isArray(varBinding) || ArrayFieldElementTypeCheck.hasArrayTypeTag(directive)) continue;
                this.getContext().createLineViolation((CodeCheck)this, "Define the element type for this ''{0}'' array", varBinding, new Object[]{varBinding.getFirstChild(new AstNodeType[]{FlexGrammar.TYPED_IDENTIFIER}).getFirstChild(new AstNodeType[]{FlexGrammar.IDENTIFIER}).getTokenValue()});
            }
        }
    }

    private static boolean hasInitialisation(AstNode varBinding) {
        return varBinding.getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_INITIALISATION}) != null;
    }

    private static boolean isArray(AstNode varBinding) {
        AstNode typeExpr = varBinding.getFirstChild(new AstNodeType[]{FlexGrammar.TYPED_IDENTIFIER}).getFirstChild(new AstNodeType[]{FlexGrammar.TYPE_EXPR});
        return typeExpr != null && typeExpr.getNumberOfChildren() == 1 && "Array".equals(typeExpr.getFirstChild().getTokenValue());
    }

    private static boolean hasArrayTypeTag(AstNode directive) {
        for (AstNode previousDirective = directive.getPreviousAstNode(); previousDirective != null && MetadataTag.isMetadataTag(previousDirective); previousDirective = previousDirective.getPreviousAstNode()) {
            if (!MetadataTag.isTag(previousDirective.getFirstChild().getFirstChild(new AstNodeType[]{FlexGrammar.METADATA_STATEMENT}), "ArrayElementType")) continue;
            return true;
        }
        return false;
    }
}

