/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.api.FlexMetric;
import org.sonar.flex.checks.utils.FlexCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.SourceClass;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.checks.ChecksHelper;
import org.sonar.squidbridge.measures.MetricDef;

@Rule(key="ClassComplexity", name="Classes should not be too complex", priority=Priority.MAJOR, tags={"brain-overload"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleLinearWithOffsetRemediation(coeff="1min", offset="10min", effortToFixDescription="per complexity point over the threshold")
public class ClassComplexityCheck
extends FlexCheck {
    private static final int DEFAULT_MAXIMUM_CLASS_COMPLEXITY_THRESHOLD = 80;
    @RuleProperty(key="maximumClassComplexityThreshold", description="Maximum complexity allowed.", defaultValue="80")
    private int maximumClassComplexityThreshold = 80;

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.CLASS_DEF});
    }

    public void leaveNode(AstNode node) {
        SourceClass sourceClass = (SourceClass)this.getContext().peekSourceCode();
        int complexity = ChecksHelper.getRecursiveMeasureInt((SourceCode)sourceClass, (MetricDef)FlexMetric.COMPLEXITY);
        if (complexity > this.maximumClassComplexityThreshold) {
            String message = String.format("Class has a complexity of %s which is greater than %s authorized.", complexity, this.maximumClassComplexityThreshold);
            this.createIssueWithCost(message, node, (double)complexity - (double)this.maximumClassComplexityThreshold);
        }
    }

    public void setMaximumClassComplexityThreshold(int threshold) {
        this.maximumClassComplexityThreshold = threshold;
    }
}

