/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.flex.checks.utils.Modifiers;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1820", name="Classes should not have too many fields", priority=Priority.MAJOR, tags={"brain-overload"})
@SqaleSubCharacteristic(value="ARCHITECTURE_CHANGEABILITY")
@SqaleConstantRemediation(value="1h")
public class ClassWithTooManyFieldsCheck
extends SquidCheck<LexerlessGrammar> {
    public static final int DEFAULT_MAX = 20;
    public static final boolean DEFAULT_COUNT_NON_PUBLIC = true;
    @RuleProperty(key="maximumFieldThreshold", description="The maximum number of fields", defaultValue="20")
    int maximumFieldThreshold = 20;
    @RuleProperty(key="countNonpublicFields", description="Whether or not to include non-public fields in the count", defaultValue="true", type="BOOLEAN")
    boolean countNonpublicFields = true;

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.CLASS_DEF});
    }

    public void visitNode(AstNode astNode) {
        int nbFields = this.getNumberOfFields(astNode);
        if (nbFields > this.maximumFieldThreshold) {
            String msg = this.countNonpublicFields ? String.valueOf(this.maximumFieldThreshold) : this.maximumFieldThreshold + " public";
            this.getContext().createLineViolation((CodeCheck)this, "Refactor this class so it has no more than {0} fields, rather than the {1} it currently has.", astNode, new Object[]{msg, nbFields});
        }
    }

    private int getNumberOfFields(AstNode classDef) {
        List<AstNode> fields = Clazz.getFields(classDef);
        int nbFields = fields.size();
        if (!this.countNonpublicFields) {
            nbFields -= ClassWithTooManyFieldsCheck.getNumberOfNonPublicFields(fields);
        }
        return nbFields;
    }

    private static int getNumberOfNonPublicFields(List<AstNode> fields) {
        int nbNonPublicFields = 0;
        for (AstNode field : fields) {
            if (!Modifiers.isNonPublic(Modifiers.getModifiers(field.getPreviousAstNode()))) continue;
            ++nbNonPublicFields;
        }
        return nbNonPublicFields;
    }
}

