/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.flex.checks.utils.Modifiers;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1448", name="Classes should not have too many methods", priority=Priority.MAJOR, tags={"brain-overload"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_CHANGEABILITY")
@SqaleConstantRemediation(value="1h")
public class ClassWithTooManyFunctionsCheck
extends SquidCheck<LexerlessGrammar> {
    private static final int DEFAULT_MAX = 20;
    private static final boolean DEFAULT_INCLUDE_NON_PUBLIC = true;
    @RuleProperty(key="maximumFunctionThreshold", description="The maximum number of methods", defaultValue="20")
    int maximumFunctionThreshold = 20;
    @RuleProperty(key="countNonpublicMethods", description="Whether or not to include non-public methods in the count", defaultValue="true", type="BOOLEAN")
    boolean countNonpublicMethods = true;

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.CLASS_DEF});
    }

    public void visitNode(AstNode astNode) {
        int nbMethods = this.getNumberOfMethods(astNode);
        if (nbMethods > this.maximumFunctionThreshold) {
            this.getContext().createLineViolation((CodeCheck)this, "Class \"{0}\" has {1} methods, which is greater than {2} authorized. Split it into smaller classes.", astNode, new Object[]{Clazz.getName(astNode), nbMethods, this.maximumFunctionThreshold});
        }
    }

    private int getNumberOfMethods(AstNode classNode) {
        List<AstNode> methods = Clazz.getFunctions(classNode);
        int nbMethods = methods.size();
        if (!this.countNonpublicMethods) {
            nbMethods -= ClassWithTooManyFunctionsCheck.getNumberOfNonPublicMethods(methods);
        }
        return nbMethods;
    }

    private static int getNumberOfNonPublicMethods(List<AstNode> methods) {
        int nbNonPublicMethod = 0;
        for (AstNode method : methods) {
            if (!Modifiers.isNonPublic(Modifiers.getModifiers(method.getPreviousAstNode()))) continue;
            ++nbNonPublicMethod;
        }
        return nbNonPublicMethod;
    }
}

