/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexKeyword;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.squidbridge.recognizer.CodeRecognizer;
import org.sonar.squidbridge.recognizer.ContainsDetector;
import org.sonar.squidbridge.recognizer.Detector;
import org.sonar.squidbridge.recognizer.EndWithDetector;
import org.sonar.squidbridge.recognizer.KeywordsDetector;
import org.sonar.squidbridge.recognizer.LanguageFootprint;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="CommentedCode", name="Sections of code should not be \"commented out\"", priority=Priority.MAJOR, tags={"misra", "unused"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class CommentedCodeCheck
extends SquidCheck<LexerlessGrammar>
implements AstAndTokenVisitor {
    private static final double THRESHOLD = 0.9;
    private final CodeRecognizer codeRecognizer = new CodeRecognizer(0.9, (LanguageFootprint)new FlexRecognizer());
    private final Pattern regexpToDivideStringByLine = Pattern.compile("(\r?\n)|(\r)");

    public void visitToken(Token token) {
        block0: for (Trivia trivia : token.getTrivia()) {
            if (!trivia.isComment()) continue;
            String[] lines = this.regexpToDivideStringByLine.split(this.getContext().getCommentAnalyser().getContents(trivia.getToken().getOriginalValue()));
            for (int lineOffset = 0; lineOffset < lines.length; ++lineOffset) {
                if (!this.codeRecognizer.isLineOfCode(lines[lineOffset])) continue;
                this.getContext().createLineViolation((CodeCheck)this, "Sections of code should not be \"commented out\".", trivia.getToken().getLine() + lineOffset, new Object[0]);
                continue block0;
            }
        }
    }

    private static class FlexRecognizer
    implements LanguageFootprint {
        private FlexRecognizer() {
        }

        public Set<Detector> getDetectors() {
            return ImmutableSet.of((Object)new EndWithDetector(0.95, new char[]{'}', ';', '{'}), (Object)new KeywordsDetector(0.3, FlexKeyword.keywordValues()), (Object)new ContainsDetector(0.95, new String[]{"++", "--"}), (Object)new ContainsDetector(0.95, new String[]{"*=", "/=", "%=", "+=", "-=", "<<=", ">>=", ">>>=", "&=", "^=", "|="}), (Object)new ContainsDetector(0.95, new String[]{"==", "!=", "===", "!=="}));
        }
    }
}

