/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1871", name="Two branches in the same conditional structure should not have exactly the same implementation", priority=Priority.MAJOR, tags={"design", "suspicious"})
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class DuplicateSwitchCaseImplementationCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.SWITCH_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        LinkedHashMap cases = Maps.newLinkedHashMap();
        for (AstNode caseElement : astNode.getChildren(new AstNodeType[]{FlexGrammar.CASE_ELEMENT})) {
            AstNode caseLabel = caseElement.getLastChild(new AstNodeType[]{FlexGrammar.CASE_LABEL});
            List<Token> tokens = DuplicateSwitchCaseImplementationCheck.getCaseImplementationTokens(caseElement);
            if (tokens.isEmpty()) continue;
            AstNode duplicatedCase = DuplicateSwitchCaseImplementationCheck.getDuplicatedCase(cases, tokens);
            if (duplicatedCase != null) {
                this.getContext().createLineViolation((CodeCheck)this, "Either merge this case with the identical one on line \"{0}\" or change one of the implementations.", caseElement, new Object[]{duplicatedCase.getTokenLine()});
                continue;
            }
            cases.put(caseLabel, tokens);
        }
    }

    private static List<Token> getCaseImplementationTokens(AstNode caseElement) {
        ArrayList tokens = Lists.newArrayList();
        for (AstNode directive : caseElement.getChildren(new AstNodeType[]{FlexGrammar.DIRECTIVE})) {
            tokens.addAll(directive.getTokens());
        }
        return tokens;
    }

    @Nullable
    private static AstNode getDuplicatedCase(Map<AstNode, List<Token>> cases, List<Token> tokens) {
        for (Map.Entry<AstNode, List<Token>> entry : cases.entrySet()) {
            if (!DuplicateSwitchCaseImplementationCheck.areTokenValuesIdentical(entry.getValue(), tokens)) continue;
            return entry.getKey();
        }
        return null;
    }

    private static boolean areTokenValuesIdentical(List<Token> implementation1, List<Token> implementation2) {
        int nbToken = implementation1.size();
        if (implementation2.size() != nbToken) {
            return false;
        }
        for (int i = 0; i < nbToken; ++i) {
            if (implementation1.get(i).getValue().equals(implementation2.get(i).getValue())) continue;
            return false;
        }
        return true;
    }
}

