/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexKeyword;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1466", name="The flash.system.Security.exactSettings property should never be set to false", priority=Priority.CRITICAL, tags={"security"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="10min")
public class ExactSettingsSetToFalseCheck
extends SquidCheck<LexerlessGrammar>
implements AstAndTokenVisitor {
    private static final State[][] TRANSITIONS = new State[State.values().length][Symbol.values().length];
    private State currentState;

    public void visitFile(@Nullable AstNode node) {
        this.currentState = State.EXPECTING_SECURITY;
    }

    public void visitToken(Token token) {
        this.currentState = TRANSITIONS[this.currentState.ordinal()][ExactSettingsSetToFalseCheck.getSymbol(token.getOriginalValue()).ordinal()];
        if (this.currentState == State.FOUND_ISSUE) {
            this.getContext().createLineViolation((CodeCheck)this, "Set flash.system.Security.exactSettings to true", token, new Object[0]);
            this.currentState = State.EXPECTING_SECURITY;
        }
    }

    private static Symbol getSymbol(String value) {
        Symbol result = Symbol.OTHER;
        if (".".equals(value)) {
            result = Symbol.DOT;
        } else if ("Security".equals(value)) {
            result = Symbol.SECURITY;
        } else if ("exactSettings".equals(value)) {
            result = Symbol.EXACT_SETTINGS;
        } else if ("=".equals(value)) {
            result = Symbol.EQUAL;
        } else if (FlexKeyword.FALSE.getValue().equals(value)) {
            result = Symbol.FALSE;
        }
        return result;
    }

    static {
        for (int i = 0; i < TRANSITIONS.length; ++i) {
            for (int j = 0; j < TRANSITIONS[i].length; ++j) {
                ExactSettingsSetToFalseCheck.TRANSITIONS[i][j] = State.EXPECTING_SECURITY;
            }
        }
        ExactSettingsSetToFalseCheck.TRANSITIONS[State.EXPECTING_SECURITY.ordinal()][Symbol.SECURITY.ordinal()] = State.EXPECTING_DOT;
        ExactSettingsSetToFalseCheck.TRANSITIONS[State.EXPECTING_DOT.ordinal()][Symbol.DOT.ordinal()] = State.EXPECTING_EXACT_SETTINGS;
        ExactSettingsSetToFalseCheck.TRANSITIONS[State.EXPECTING_EXACT_SETTINGS.ordinal()][Symbol.EXACT_SETTINGS.ordinal()] = State.EXPECTING_EQUAL;
        ExactSettingsSetToFalseCheck.TRANSITIONS[State.EXPECTING_EQUAL.ordinal()][Symbol.EQUAL.ordinal()] = State.EXPECTING_FALSE;
        ExactSettingsSetToFalseCheck.TRANSITIONS[State.EXPECTING_FALSE.ordinal()][Symbol.FALSE.ordinal()] = State.FOUND_ISSUE;
    }

    private static enum Symbol {
        OTHER,
        SECURITY,
        DOT,
        EXACT_SETTINGS,
        EQUAL,
        FALSE;

    }

    private static enum State {
        EXPECTING_SECURITY,
        EXPECTING_DOT,
        EXPECTING_EXACT_SETTINGS,
        EXPECTING_EQUAL,
        EXPECTING_FALSE,
        FOUND_ISSUE;

    }
}

