/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="FunctionSinglePointOfExit", name="A function should have a single point of exit at the end of the function", priority=Priority.MINOR, tags={"confusing", "misra"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="20min")
public class FunctionSinglePointOfExitCheck
extends SquidCheck<LexerlessGrammar> {
    private int returnStatements;

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.FUNCTION_DEF, FlexGrammar.RETURN_STATEMENT});
    }

    public void visitNode(AstNode node) {
        if (node.is(new AstNodeType[]{FlexGrammar.FUNCTION_DEF})) {
            this.returnStatements = 0;
        } else if (node.is(new AstNodeType[]{FlexGrammar.RETURN_STATEMENT})) {
            ++this.returnStatements;
        }
    }

    public void leaveNode(AstNode node) {
        if (node.is(new AstNodeType[]{FlexGrammar.FUNCTION_DEF}) && this.returnStatements != 0 && (this.returnStatements > 1 || !FunctionSinglePointOfExitCheck.hasReturnAtEnd(node))) {
            this.getContext().createLineViolation((CodeCheck)this, "A function shall have a single point of exit at the end of the function.", node, new Object[0]);
        }
    }

    private static boolean hasReturnAtEnd(AstNode functionDefinitionNode) {
        AstNode statementNode;
        AstNode lastDirectiveNode = functionDefinitionNode.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_COMMON}).getFirstChild(new AstNodeType[]{FlexGrammar.BLOCK}).getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVES}).getLastChild();
        return lastDirectiveNode != null && (statementNode = lastDirectiveNode.getFirstChild(new AstNodeType[]{FlexGrammar.STATEMENT})) != null && statementNode.getFirstChild().is(new AstNodeType[]{FlexGrammar.RETURN_STATEMENT});
    }
}

