/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1145", name="Useless \"if(true) {...}\" and \"if(false){...}\" blocks should be removed", priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class IfConditionAlwaysTrueOrFalseCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.IF_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        AstNode condition;
        AstNode conditionalExpr = astNode.getFirstChild(new AstNodeType[]{FlexGrammar.PARENTHESIZED_LIST_EXPR}).getFirstChild(new AstNodeType[]{FlexGrammar.LIST_EXPRESSION});
        if (conditionalExpr.getChildren().size() == 1 && ((condition = conditionalExpr.getFirstChild().getFirstChild()).is(new AstNodeType[]{FlexGrammar.POSTFIX_EXPR}) && condition.getFirstChild().is(new AstNodeType[]{FlexGrammar.PRIMARY_EXPR}) && condition.getFirstChild().getFirstChild().is(new AstNodeType[]{FlexKeyword.TRUE}) || condition.getFirstChild().getFirstChild().is(new AstNodeType[]{FlexKeyword.FALSE}))) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove this if statement.", astNode, new Object[0]);
        }
    }
}

