/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Function;
import org.sonar.flex.checks.utils.Variable;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S117", name="Local variable and function parameter names should comply with a naming convention", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class LocalVarAndParameterNameCheck
extends SquidCheck<LexerlessGrammar> {
    private static final String DEFAULT = "^[_a-z][a-zA-Z0-9]*$";
    private static final String MESSAGE = "Rename this local variable \"{0}\" to match the regular expression {1}";
    private Pattern pattern = null;
    @RuleProperty(key="format", description="Regular expression used to check the names against.", defaultValue="^[_a-z][a-zA-Z0-9]*$")
    String format = "^[_a-z][a-zA-Z0-9]*$";

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.FUNCTION_DEF});
    }

    public void visitFile(@Nullable AstNode astNode) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format);
        }
    }

    public void visitNode(AstNode astNode) {
        this.checkFunctionParametersName(astNode);
        if (astNode.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_COMMON}).getFirstChild(new AstNodeType[]{FlexGrammar.BLOCK}) != null) {
            this.checkLocalVariableName(astNode.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_COMMON}).getFirstChild(new AstNodeType[]{FlexGrammar.BLOCK}).getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVES}).getChildren(new AstNodeType[]{FlexGrammar.DIRECTIVE}));
        }
    }

    private void checkLocalVariableName(List<AstNode> functionDirectives) {
        for (AstNode directive : functionDirectives) {
            if (!Variable.isVariable(directive)) continue;
            AstNode variableDeclStatement = directive.getFirstChild(new AstNodeType[]{FlexGrammar.ANNOTABLE_DIRECTIVE}).getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_DECLARATION_STATEMENT});
            for (AstNode identifier : Variable.getDeclaredIdentifiers(variableDeclStatement)) {
                String varName = identifier.getTokenValue();
                if (this.pattern.matcher(varName).matches()) continue;
                this.getContext().createLineViolation((CodeCheck)this, MESSAGE, identifier, new Object[]{varName, this.format});
            }
        }
    }

    private void checkFunctionParametersName(AstNode functionDef) {
        for (AstNode paramIdentifier : Function.getParametersIdentifiers(functionDef)) {
            String paramName = paramIdentifier.getTokenValue();
            if (this.pattern.matcher(paramName).matches()) continue;
            this.getContext().createLineViolation((CodeCheck)this, MESSAGE, paramIdentifier, new Object[]{paramName, this.format});
        }
    }
}

