/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.MetadataTag;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1464", name="Each ManagedEvents metadata tag should have a companion Event metadata tag", priority=Priority.BLOCKER, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ManagedEventTagWithEventCheck
extends SquidCheck<LexerlessGrammar> {
    private Map<String, Boolean> isDeclaredInEventTag = new HashMap<String, Boolean>();

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.METADATA_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        if (!MetadataTag.isTag(astNode, "ManagedEvents")) {
            return;
        }
        this.initEventMap(MetadataTag.getSinglePropertyAsList(astNode));
        this.searchEventInPreviousTag(astNode);
        this.searchEventInNextTag(astNode);
        for (Map.Entry<String, Boolean> entry : this.isDeclaredInEventTag.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            this.getContext().createLineViolation((CodeCheck)this, "The managed event {0} is either misspelled or is missing a companion Event metadata tag", astNode, new Object[]{entry.getKey()});
        }
        this.isDeclaredInEventTag.clear();
    }

    private void initEventMap(List<String> managedEventNames) {
        for (String eventName : managedEventNames) {
            this.isDeclaredInEventTag.put("\"" + eventName + "\"", false);
        }
    }

    private void searchEventInPreviousTag(AstNode metadata) {
        for (AstNode previousDirective = metadata.getParent().getParent().getPreviousAstNode(); previousDirective != null && MetadataTag.isMetadataTag(previousDirective); previousDirective = previousDirective.getPreviousAstNode()) {
            this.checkEventTag(previousDirective);
        }
    }

    private void searchEventInNextTag(AstNode metadata) {
        for (AstNode nextDirective = metadata.getParent().getParent().getNextAstNode(); nextDirective != null && MetadataTag.isMetadataTag(nextDirective); nextDirective = nextDirective.getNextAstNode()) {
            this.checkEventTag(nextDirective);
        }
    }

    private void checkEventTag(AstNode directive) {
        String eventName;
        AstNode metadataStmt = directive.getFirstChild().getFirstChild(new AstNodeType[]{FlexGrammar.METADATA_STATEMENT});
        if (MetadataTag.isTag(metadataStmt, "Event") && this.isDeclaredInEventTag.containsKey(eventName = MetadataTag.getTagPropertiesMap(metadataStmt).get("name"))) {
            this.isDeclaredInEventTag.put(eventName, true);
        }
    }
}

