/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Expression;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1982", name="\"MovieClip.onEnterFrame\" event handler should not be used", priority=Priority.MAJOR, tags={"performance"})
@SqaleSubCharacteristic(value="CPU_EFFICIENCY")
@SqaleConstantRemediation(value="20min")
public class OnEnterFrameUseCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.ASSIGNMENT_EXPR});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.getNumberOfChildren() > 1 && OnEnterFrameUseCheck.isOnEnterFrame(astNode.getFirstChild()) && OnEnterFrameUseCheck.isFunctionExpr(astNode.getLastChild())) {
            this.getContext().createLineViolation((CodeCheck)this, "Refactor this code to remove the use of \"onEnterFrame\" event handler.", astNode, new Object[0]);
        }
    }

    private static boolean isFunctionExpr(AstNode assignementExpr) {
        AstNode assignmentExprChild = assignementExpr.getFirstChild();
        return assignmentExprChild.is(new AstNodeType[]{FlexGrammar.POSTFIX_EXPR}) && assignmentExprChild.getFirstChild().getFirstChild().is(new AstNodeType[]{FlexGrammar.FUNCTION_EXPR});
    }

    private static boolean isOnEnterFrame(AstNode postfixExpr) {
        return Expression.exprToString(postfixExpr).endsWith(".onEnterFrame");
    }
}

