/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S120", name="Package names should comply with a naming convention", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="10min")
public class PackageNameCheck
extends SquidCheck<LexerlessGrammar> {
    private static final String DEFAULT = "^[a-z]+(\\.[a-z][a-z0-9]*)*$";
    private Pattern pattern = null;
    @RuleProperty(key="format", description="Regular expression used to check the package names against", defaultValue="^[a-z]+(\\.[a-z][a-z0-9]*)*$")
    String format = "^[a-z]+(\\.[a-z][a-z0-9]*)*$";

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.PACKAGE_DEF});
    }

    public void visitFile(@Nullable AstNode astNode) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format);
        }
    }

    public void visitNode(AstNode astNode) {
        String packageIdentifier;
        AstNode nameNode = astNode.getFirstChild(new AstNodeType[]{FlexGrammar.PACKAGE_NAME});
        if (nameNode != null && !this.pattern.matcher(packageIdentifier = PackageNameCheck.concatenate(nameNode)).matches()) {
            this.getContext().createLineViolation((CodeCheck)this, "Rename this package name to match the regular expression {0}", astNode, new Object[]{this.format});
        }
    }

    private static String concatenate(AstNode astNode) {
        StringBuilder sb = new StringBuilder();
        for (Token token : astNode.getTokens()) {
            sb.append(token.getValue());
        }
        return sb.toString();
    }
}

