/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.flex.checks.utils.Modifiers;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1312", name="Loggers should be \"private static const\" and should share a naming convention", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class PrivateStaticConstLoggerCheck
extends SquidCheck<LexerlessGrammar> {
    private static final String DEFAULT = "LOG(?:GER)?";
    private Pattern pattern = null;
    @RuleProperty(key="format", description="Regular expression used to check the logger names against.", defaultValue="LOG(?:GER)?")
    String format = "LOG(?:GER)?";

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.CLASS_DEF});
    }

    public void visitFile(@Nullable AstNode astNode) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format);
        }
    }

    public void visitNode(AstNode astNode) {
        for (AstNode directive : Clazz.getDirectives(astNode)) {
            if (!PrivateStaticConstLoggerCheck.isVariableDeclaration(directive)) continue;
            AstNode variableDef = directive.getFirstChild(new AstNodeType[]{FlexGrammar.ANNOTABLE_DIRECTIVE}).getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_DECLARATION_STATEMENT}).getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_DEF});
            for (AstNode variableBindingNode : variableDef.getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_BINDING_LIST}).getChildren(new AstNodeType[]{FlexGrammar.VARIABLE_BINDING})) {
                if (!PrivateStaticConstLoggerCheck.isILogger(variableBindingNode)) continue;
                AstNode identifierNode = variableBindingNode.getFirstChild(new AstNodeType[]{FlexGrammar.TYPED_IDENTIFIER}).getFirstChild(new AstNodeType[]{FlexGrammar.IDENTIFIER});
                Set<AstNodeType> modifiers = Modifiers.getModifiers(directive.getFirstChild(new AstNodeType[]{FlexGrammar.ATTRIBUTES}));
                boolean isPrivateStaticConst = modifiers.contains(FlexKeyword.PRIVATE) && modifiers.contains(FlexKeyword.STATIC) && PrivateStaticConstLoggerCheck.isConst(variableDef);
                this.reportIssue(isPrivateStaticConst, this.pattern.matcher(identifierNode.getTokenValue()).matches(), variableBindingNode);
            }
        }
    }

    private void reportIssue(boolean isPrivateStaticConst, boolean matchesFormat, AstNode identifierNode) {
        String identifier = identifierNode.getTokenValue();
        if (!isPrivateStaticConst && !matchesFormat) {
            this.getContext().createLineViolation((CodeCheck)this, "Make the logger \"{0}\" private static const and rename it to comply with the format \"{1}\".", identifierNode, new Object[]{identifier, this.format});
        } else if (!isPrivateStaticConst) {
            this.getContext().createLineViolation((CodeCheck)this, "Make the logger \"{0}\" private static const.", identifierNode, new Object[]{identifier});
        } else if (!matchesFormat) {
            this.getContext().createLineViolation((CodeCheck)this, "Rename the \"{0}\" logger to comply with the format \"{1}\".", identifierNode, new Object[]{identifier, this.format});
        }
    }

    private static boolean isILogger(AstNode variableBinding) {
        AstNode typeExpr = variableBinding.getFirstChild(new AstNodeType[]{FlexGrammar.TYPED_IDENTIFIER}).getFirstChild(new AstNodeType[]{FlexGrammar.TYPE_EXPR});
        return typeExpr != null && "ILogger".equals(typeExpr.getTokenValue());
    }

    private static boolean isConst(AstNode variableDef) {
        return variableDef.getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_DEF_KIND}).getFirstChild().is(new AstNodeType[]{FlexKeyword.CONST});
    }

    private static boolean isVariableDeclaration(AstNode directive) {
        return directive.getFirstChild(new AstNodeType[]{FlexGrammar.ANNOTABLE_DIRECTIVE}) != null && directive.getFirstChild(new AstNodeType[]{FlexGrammar.ANNOTABLE_DIRECTIVE}).getFirstChild().is(new AstNodeType[]{FlexGrammar.VARIABLE_DECLARATION_STATEMENT});
    }
}

