/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.flex.checks.utils.Modifiers;
import org.sonar.flex.checks.utils.Variable;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1170", name="Public constants and fields initialized at declaration should be \"const static\" rather than merely \"const\"", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="MEMORY_EFFICIENCY")
@SqaleConstantRemediation(value="2min")
public class PublicConstNotStaticCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.CLASS_DEF});
    }

    public void visitNode(AstNode astNode) {
        for (AstNode directive : Clazz.getDirectives(astNode)) {
            Set<AstNodeType> varModifiers;
            if (!Variable.isConst(directive) || !(varModifiers = Modifiers.getModifiers(directive.getFirstChild(new AstNodeType[]{FlexGrammar.ATTRIBUTES}))).contains(FlexKeyword.PUBLIC) || varModifiers.contains(FlexKeyword.STATIC)) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Make this const field \"{0}\" static too", directive, new Object[]{Variable.getName(directive.getFirstChild(new AstNodeType[]{FlexGrammar.ANNOTABLE_DIRECTIVE}).getFirstChild())});
        }
    }
}

