/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexPunctuator;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1435", name="The special \"star\" type should not be used", priority=Priority.MAJOR, tags={"unpredictable"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_CHANGEABILITY")
@SqaleConstantRemediation(value="10min")
public class StarTypeUseCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.VARIABLE_BINDING});
    }

    public void visitNode(AstNode astNode) {
        AstNode typeExprNode = astNode.getFirstChild(new AstNodeType[]{FlexGrammar.TYPED_IDENTIFIER}).getFirstChild(new AstNodeType[]{FlexGrammar.TYPE_EXPR});
        if (typeExprNode != null && typeExprNode.getFirstChild(new AstNodeType[]{FlexPunctuator.STAR}) != null) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove usage of this \"star\" type", typeExprNode, new Object[0]);
        }
    }
}

