/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1468", name="Security.allowDomain(...) should only be used in a tightly focused manner", priority=Priority.CRITICAL, tags={"security"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="10min")
public class StarUseForDomainCheck
extends SquidCheck<LexerlessGrammar>
implements AstAndTokenVisitor {
    private static final State[][] TRANSITIONS = new State[State.values().length][Symbol.values().length];
    private State currentState;

    public void visitFile(@Nullable AstNode node) {
        this.currentState = State.EXPECTING_SECURITY;
    }

    public void visitToken(Token token) {
        this.currentState = TRANSITIONS[this.currentState.ordinal()][StarUseForDomainCheck.getSymbol(token.getOriginalValue()).ordinal()];
        if (this.currentState == State.FOUND_ISSUE) {
            this.getContext().createLineViolation((CodeCheck)this, "Specifically define the origin domain of SWF files that are allowed to communicate with this one", token, new Object[0]);
            this.currentState = State.EXPECTING_SECURITY;
        }
    }

    private static Symbol getSymbol(String value) {
        Symbol result = Symbol.OTHER;
        if (".".equals(value)) {
            result = Symbol.DOT;
        } else if ("Security".equals(value)) {
            result = Symbol.SECURITY;
        } else if ("allowDomain".equals(value)) {
            result = Symbol.ALLOW_DOMAIN;
        } else if ("(".equals(value)) {
            result = Symbol.RCURLY;
        } else if ("\"*\"".equals(value)) {
            result = Symbol.STAR;
        }
        return result;
    }

    static {
        for (int i = 0; i < TRANSITIONS.length; ++i) {
            for (int j = 0; j < TRANSITIONS[i].length; ++j) {
                StarUseForDomainCheck.TRANSITIONS[i][j] = State.EXPECTING_SECURITY;
            }
        }
        StarUseForDomainCheck.TRANSITIONS[State.EXPECTING_SECURITY.ordinal()][Symbol.SECURITY.ordinal()] = State.EXPECTING_DOT;
        StarUseForDomainCheck.TRANSITIONS[State.EXPECTING_DOT.ordinal()][Symbol.DOT.ordinal()] = State.EXPECTING_ALLOW_DOMAIN;
        StarUseForDomainCheck.TRANSITIONS[State.EXPECTING_ALLOW_DOMAIN.ordinal()][Symbol.ALLOW_DOMAIN.ordinal()] = State.EXPECTING_LCURLY;
        StarUseForDomainCheck.TRANSITIONS[State.EXPECTING_LCURLY.ordinal()][Symbol.RCURLY.ordinal()] = State.EXPECTING_STAR;
        StarUseForDomainCheck.TRANSITIONS[State.EXPECTING_STAR.ordinal()][Symbol.STAR.ordinal()] = State.FOUND_ISSUE;
    }

    private static enum Symbol {
        OTHER,
        SECURITY,
        DOT,
        ALLOW_DOMAIN,
        RCURLY,
        STAR;

    }

    private static enum State {
        EXPECTING_SECURITY,
        EXPECTING_DOT,
        EXPECTING_ALLOW_DOMAIN,
        EXPECTING_LCURLY,
        EXPECTING_STAR,
        FOUND_ISSUE;

    }
}

