/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.FlexPunctuator;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="SwitchWithoutDefault", name="\"switch\" statements should end with a \"default\" clause", priority=Priority.MAJOR, tags={"cwe", "cert", "misra"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class SwitchWithoutDefaultCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.SWITCH_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        AstNode defaultCaseElement = null;
        block0: for (AstNode caseElementNode : astNode.getChildren(new AstNodeType[]{FlexGrammar.CASE_ELEMENT})) {
            for (AstNode caseLabelNode : caseElementNode.getChildren(new AstNodeType[]{FlexGrammar.CASE_LABEL})) {
                if (!caseLabelNode.getFirstChild().is(new AstNodeType[]{FlexKeyword.DEFAULT})) continue;
                defaultCaseElement = caseElementNode;
                continue block0;
            }
        }
        if (defaultCaseElement == null) {
            this.getContext().createLineViolation((CodeCheck)this, "Avoid switch statement without a \"default\" clause.", astNode, new Object[0]);
        } else if (defaultCaseElement.getNextSibling().isNot(new AstNodeType[]{FlexPunctuator.RCURLYBRACE})) {
            this.getContext().createLineViolation((CodeCheck)this, "\"default\" clause should be the last one.", astNode, new Object[0]);
        }
    }
}

