/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexPunctuator;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S138", name="Functions should not have too many lines", priority=Priority.MAJOR, tags={"brain-overload"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="20min")
public class TooManyLinesInFunctionCheck
extends SquidCheck<LexerlessGrammar> {
    private static final int DEFAULT = 100;
    @RuleProperty(key="max", description="Maximum authorized lines in a function", defaultValue="100")
    int max = 100;

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.FUNCTION_DEF, FlexGrammar.FUNCTION_EXPR});
    }

    public void visitNode(AstNode astNode) {
        int nbLines = TooManyLinesInFunctionCheck.getNumberOfLine(astNode);
        if (nbLines > this.max) {
            this.getContext().createLineViolation((CodeCheck)this, "This function has {0} lines, which is greater than the {1} lines authorized. Split it into smaller functions.", astNode, new Object[]{nbLines, this.max});
        }
    }

    public static int getNumberOfLine(AstNode functionNode) {
        AstNode blockNode = functionNode.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_COMMON}).getFirstChild(new AstNodeType[]{FlexGrammar.BLOCK});
        if (blockNode != null) {
            int firstLine = blockNode.getFirstChild(new AstNodeType[]{FlexPunctuator.LCURLYBRACE}).getTokenLine();
            int lastLine = blockNode.getFirstChild(new AstNodeType[]{FlexPunctuator.RCURLYBRACE}).getTokenLine();
            return lastLine - firstLine + 1;
        }
        return 0;
    }
}

