/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1142", name="Functions should not contain too many return statements", priority=Priority.MAJOR, tags={"brain-overload"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="20min")
public class TooManyReturnCheck
extends SquidCheck<LexerlessGrammar> {
    private static final int DEFAULT = 3;
    private final Deque<Integer> returnStatementCounter = new ArrayDeque<Integer>();
    @RuleProperty(key="max", description="Maximum allowed return statements per function", defaultValue="3")
    int max = 3;

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.FUNCTION_COMMON, FlexGrammar.RETURN_STATEMENT});
    }

    public void visitFile(@Nullable AstNode astNode) {
        this.returnStatementCounter.clear();
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{FlexGrammar.RETURN_STATEMENT})) {
            this.setReturnStatementCounter(this.getReturnStatementCounter() + 1);
        } else {
            this.returnStatementCounter.push(0);
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{FlexGrammar.FUNCTION_COMMON})) {
            if (this.getReturnStatementCounter() > this.max) {
                this.getContext().createLineViolation((CodeCheck)this, "Reduce the number of returns of this function {0,number,integer}, down to the maximum allowed {1,number,integer}.", astNode, new Object[]{this.getReturnStatementCounter(), this.max});
            }
            this.returnStatementCounter.pop();
        }
    }

    private int getReturnStatementCounter() {
        return this.returnStatementCounter.peek();
    }

    private void setReturnStatementCounter(int value) {
        this.returnStatementCounter.pop();
        this.returnStatementCounter.push(value);
    }
}

