/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexPunctuator;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1454", name="Multiple \"++\" or \"--\" unary operators should not be used in a single arithmetic expression", priority=Priority.MINOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="2min")
public class TooManyUnaryOperatorCheck
extends SquidCheck<LexerlessGrammar> {
    private boolean assignmentExpression;
    private int counter;

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.ASSIGNMENT_EXPR, FlexPunctuator.DOUBLE_MINUS, FlexPunctuator.DOUBLE_PLUS});
    }

    public void visitFile(@Nullable AstNode astNode) {
        this.assignmentExpression = false;
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{FlexGrammar.ASSIGNMENT_EXPR})) {
            this.assignmentExpression = true;
        } else if (this.assignmentExpression && (astNode.is(new AstNodeType[]{FlexPunctuator.DOUBLE_MINUS}) || astNode.is(new AstNodeType[]{FlexPunctuator.DOUBLE_PLUS}))) {
            ++this.counter;
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{FlexGrammar.ASSIGNMENT_EXPR})) {
            if (this.counter > 1) {
                this.getContext().createLineViolation((CodeCheck)this, "Split this expression into multiple expressions so that each one contains no more than a single \"++\" or \"--\" unary operator", astNode, new Object[0]);
            }
            this.assignmentExpression = false;
            this.counter = 0;
        }
    }
}

