/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.flex.checks.utils.Modifiers;
import org.sonar.flex.checks.utils.Variable;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1068", name="Unused private fields should be removed", priority=Priority.MAJOR, tags={"unused"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class UnusedPrivateFieldCheck
extends SquidCheck<LexerlessGrammar> {
    private Deque<ClassState> classStack = new ArrayDeque<ClassState>();

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.CLASS_DEF, FlexGrammar.QUALIFIED_IDENTIFIER});
    }

    public void visitFile(@Nullable AstNode astNode) {
        this.classStack.clear();
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{FlexGrammar.CLASS_DEF})) {
            this.classStack.push(new ClassState(astNode));
        } else if (!this.classStack.isEmpty() && astNode.is(new AstNodeType[]{FlexGrammar.QUALIFIED_IDENTIFIER})) {
            this.classStack.peek().use(astNode);
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{FlexGrammar.CLASS_DEF})) {
            this.reportUnusedPrivateField();
        }
    }

    private void reportUnusedPrivateField() {
        for (Map.Entry entry : this.classStack.pop().privateFields.entrySet()) {
            if (((PrivateField)entry.getValue()).usages != 0) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Remove this unused ''{0}'' private field", ((PrivateField)entry.getValue()).declaration, new Object[]{entry.getKey()});
        }
    }

    private static class ClassState {
        private final Map<String, PrivateField> privateFields = Maps.newHashMap();

        public ClassState(AstNode classDef) {
            this.retrieveAllPrivateFields(classDef);
        }

        private void retrieveAllPrivateFields(AstNode classDef) {
            for (AstNode varDeclaration : Clazz.getFields(classDef)) {
                if (!Modifiers.getModifiers(varDeclaration.getParent().getPreviousAstNode()).contains(FlexKeyword.PRIVATE)) continue;
                for (AstNode identifier : Variable.getDeclaredIdentifiers(varDeclaration)) {
                    this.privateFields.put(identifier.getTokenValue(), new PrivateField(identifier, 0));
                }
            }
        }

        private void use(AstNode astNode) {
            PrivateField field = this.privateFields.get(astNode.getTokenValue());
            if (field != null) {
                ++field.usages;
                return;
            }
        }
    }

    private static class PrivateField {
        final AstNode declaration;
        int usages;

        public PrivateField(AstNode declaration, int usages) {
            this.declaration = declaration;
            this.usages = usages;
        }
    }
}

