/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks.asdoc;

import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Trivia;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.ASDocCheck;
import org.sonar.flex.checks.utils.Function;
import org.sonar.flex.checks.utils.Modifiers;
import org.sonar.squidbridge.api.CodeCheck;

public class ASDocMemberCheck {
    public void visitNode(ASDocCheck check, List<AstNode> classDirectives) {
        this.checkMember(check, classDirectives);
    }

    private void checkMember(ASDocCheck check, List<AstNode> classDirectives) {
        for (AstNode directive : classDirectives) {
            AstNode annotableDirective = directive.getFirstChild(new AstNodeType[]{FlexGrammar.ANNOTABLE_DIRECTIVE});
            if (annotableDirective == null || !Modifiers.isPublic(annotableDirective.getPreviousAstNode())) continue;
            AstNode annotableDirChild = annotableDirective.getFirstChild();
            if (check.properties && annotableDirChild.is(new AstNodeType[]{FlexGrammar.VARIABLE_DECLARATION_STATEMENT})) {
                ASDocMemberCheck.checkField(check, ASDocMemberCheck.getTrivia(directive), annotableDirChild);
                continue;
            }
            if (!check.methods || !annotableDirChild.is(new AstNodeType[]{FlexGrammar.FUNCTION_DEF})) continue;
            this.checkMethod(check, ASDocMemberCheck.getTrivia(directive), annotableDirChild);
        }
    }

    private static List<Trivia> getTrivia(AstNode directive) {
        if (directive.getToken().hasTrivia()) {
            return directive.getToken().getTrivia();
        }
        AstNode current = directive;
        AstNode previousNode = directive.getPreviousAstNode();
        while (ASDocMemberCheck.isMetadata(previousNode)) {
            current = previousNode;
            previousNode = previousNode.getPreviousAstNode();
        }
        return current.getToken().getTrivia();
    }

    private static boolean isMetadata(AstNode directive) {
        AstNode statementKind = directive.getFirstChild().getFirstChild();
        return statementKind != null && statementKind.is(new AstNodeType[]{FlexGrammar.METADATA_STATEMENT});
    }

    private static void checkField(ASDocCheck check, List<Trivia> trivia, AstNode variableDec) {
        if (!check.hasASDoc(trivia) && !check.containsOnOfTags(trivia, "@private", "@inheritDoc")) {
            check.getContext().createLineViolation((CodeCheck)check, "Add the missing ASDoc for this field declaration.", variableDec, new Object[0]);
        }
    }

    private void checkMethod(ASDocCheck check, List<Trivia> trivia, AstNode functionDef) {
        if (check.containsOnOfTags(trivia, "@private", "@inheritDoc")) {
            return;
        }
        if (!check.hasASDoc(trivia)) {
            check.getContext().createLineViolation((CodeCheck)check, "Add the missing ASDoc for this method.", functionDef, new Object[0]);
        } else {
            MethodASDoc methodASDoc = this.parseASDoc(trivia);
            if (check.methodReturn) {
                this.checkForReturnASDoc(check, methodASDoc, functionDef);
            }
            if (check.methodParams) {
                this.checkForParametersASDoc(check, methodASDoc, functionDef);
            }
        }
    }

    private void checkForReturnASDoc(ASDocCheck check, MethodASDoc methodASDoc, AstNode functionDef) {
        if (!ASDocMemberCheck.returnsVoid(functionDef) && !methodASDoc.hasReturn) {
            check.getContext().createLineViolation((CodeCheck)check, "Add the missing \"@return\" ASDoc for the return value of this method.", functionDef, new Object[0]);
        }
    }

    private void checkForParametersASDoc(ASDocCheck check, MethodASDoc methodASDoc, AstNode functionDef) {
        StringBuilder builder = new StringBuilder();
        for (AstNode parameter : Function.getParametersIdentifiers(functionDef)) {
            String paramValue = parameter.getTokenValue();
            if (methodASDoc.isParameterDocumented(paramValue)) continue;
            builder.append(paramValue).append(", ");
        }
        if (builder.length() > 0) {
            check.getContext().createLineViolation((CodeCheck)check, "Add the missing \"@param\" ASDoc for: {0}.", functionDef, new Object[]{StringUtils.chop((String)builder.toString().trim())});
        }
    }

    private MethodASDoc parseASDoc(List<Trivia> trivia) {
        MethodASDoc methodASDoc = new MethodASDoc();
        for (Trivia comment : trivia) {
            for (String line : comment.getToken().getValue().trim().split("(?:\r)?\n|\r")) {
                this.parseLine(line.trim().split(" "), methodASDoc);
            }
        }
        return methodASDoc;
    }

    private void parseLine(String[] line, MethodASDoc methodASDoc) {
        int lineLength = line.length;
        int i = 0;
        int next = 1;
        while (i < lineLength) {
            if ("@param".equals(line[i]) && next < lineLength) {
                methodASDoc.parameters.add(ASDocMemberCheck.getParamName(line[next]));
            } else if ("@return".equals(line[i])) {
                methodASDoc.hasReturn = true;
            }
            ++i;
            ++next;
        }
    }

    private static boolean returnsVoid(AstNode functionDef) {
        AstNode returnType = functionDef.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_COMMON}).getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_SIGNATURE}).getFirstChild(new AstNodeType[]{FlexGrammar.RESULT_TYPE});
        if (returnType == null) {
            return true;
        }
        return returnType.getLastChild().is(new AstNodeType[]{FlexKeyword.VOID});
    }

    private static String getParamName(String paramDoc) {
        if (!paramDoc.isEmpty()) {
            return paramDoc.split(":")[0];
        }
        return paramDoc;
    }

    public static class MethodASDoc {
        Set<String> parameters = Sets.newHashSet();
        boolean hasReturn = false;

        public boolean isParameterDocumented(String paramName) {
            for (String param : this.parameters) {
                if (!param.equalsIgnoreCase(paramName)) continue;
                return true;
            }
            return false;
        }
    }
}

