/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1125", name="Literal boolean values should not be used in condition expressions", tags={"clumsy"}, priority=Priority.MINOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class BooleanEqualityComparisonCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.EQUALITY_EXPR});
    }

    public void visitNode(AstNode astNode) {
        if (BooleanEqualityComparisonCheck.hasBooleanLiteralOperand(astNode.getFirstChild(new AstNodeType[]{FlexGrammar.EQUALITY_OPERATOR}).getNextAstNode())) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove the unnecessary boolean comparison to simplify this expression.", astNode, new Object[0]);
        }
    }

    private static boolean hasBooleanLiteralOperand(AstNode astNode) {
        return astNode.is(new AstNodeType[]{FlexGrammar.POSTFIX_EXPR}) && astNode.getFirstChild().is(new AstNodeType[]{FlexGrammar.PRIMARY_EXPR}) && astNode.getFirstChild().getFirstChild().is(new AstNodeType[]{FlexKeyword.TRUE, FlexKeyword.FALSE});
    }
}

