/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Variable;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S115", name="Constant names should comply with a naming convention", tags={"convention"}, priority=Priority.MINOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class ConstantNameCheck
extends SquidCheck<LexerlessGrammar> {
    private static final String DEFAULT = "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$";
    private Pattern pattern = null;
    @RuleProperty(key="format", description="Regular expression used to check the constant names against", defaultValue="^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$")
    String format = "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$";

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.VARIABLE_DECLARATION_STATEMENT});
    }

    public void visitFile(@Nullable AstNode astNode) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format);
        }
    }

    public void visitNode(AstNode astNode) {
        if (astNode.getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_DEF}).getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_DEF_KIND}).getFirstChild(new AstNodeType[]{FlexKeyword.CONST}) != null) {
            for (AstNode identifier : Variable.getDeclaredIdentifiers(astNode)) {
                String varName = identifier.getTokenValue();
                if (this.pattern.matcher(varName).matches()) continue;
                this.getContext().createLineViolation((CodeCheck)this, "Rename this constant '" + varName + "' to match the regular expression " + this.format + "", identifier, new Object[0]);
            }
        }
    }
}

