/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S134", name="Control flow statements \"if\", \"for\", \"while\" and \"switch\" should not be nested too deeply", tags={"brain-overload"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_CHANGEABILITY")
@SqaleConstantRemediation(value="10min")
public class ControlFlowStmtDepthCheck
extends SquidCheck<LexerlessGrammar> {
    private int nestingLevel;
    private static final int DEFAULT_MAX = 3;
    @RuleProperty(key="max", description="Maximum allowed control flow statement nesting depth.", defaultValue="3")
    public int max = 3;

    public int getMax() {
        return this.max;
    }

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.IF_STATEMENT, FlexGrammar.DO_STATEMENT, FlexGrammar.WHILE_STATEMENT, FlexGrammar.FOR_STATEMENT, FlexGrammar.SWITCH_STATEMENT});
    }

    public void visitFile(@Nullable AstNode astNode) {
        this.nestingLevel = 0;
    }

    public void visitNode(AstNode astNode) {
        if (!ControlFlowStmtDepthCheck.isElseIf(astNode)) {
            ++this.nestingLevel;
            if (this.nestingLevel == this.getMax() + 1) {
                this.getContext().createLineViolation((CodeCheck)this, "Refactor this code to not nest more than {0} if/for/while/switch statements.", astNode, new Object[]{this.getMax()});
            }
        }
    }

    public void leaveNode(AstNode astNode) {
        if (!ControlFlowStmtDepthCheck.isElseIf(astNode)) {
            --this.nestingLevel;
        }
    }

    private static boolean isElseIf(AstNode astNode) {
        return astNode.getParent().getParent().getPreviousSibling() != null && astNode.getParent().getParent().getPreviousSibling().is(new AstNodeType[]{FlexKeyword.ELSE});
    }
}

